/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.jps.serialization;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.util.PathUtil;
import com.intellij.workspaceModel.ide.JpsFileEntitySource;
import com.intellij.workspaceModel.ide.JpsProjectConfigLocation;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsExternalStorageMapping;
import com.intellij.workspaceModel.storage.VirtualFileUrl;
import com.intellij.workspaceModel.storage.VirtualFileUrlKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMappingImpl;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsExternalStorageMapping;", "externalStorageRoot", "Lcom/intellij/workspaceModel/storage/VirtualFileUrl;", "projectLocation", "Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;", "(Lcom/intellij/workspaceModel/storage/VirtualFileUrl;Lcom/intellij/workspaceModel/ide/JpsProjectConfigLocation;)V", "getExternalStorageRoot", "()Lcom/intellij/workspaceModel/storage/VirtualFileUrl;", "getExternalSource", "Lcom/intellij/workspaceModel/ide/JpsFileEntitySource;", "internalSource", "intellij.platform.workspaceModel.ide"})
public final class JpsExternalStorageMappingImpl
implements JpsExternalStorageMapping {
    @NotNull
    private final VirtualFileUrl externalStorageRoot;
    private final JpsProjectConfigLocation projectLocation;

    @Override
    @NotNull
    public JpsFileEntitySource getExternalSource(@NotNull JpsFileEntitySource internalSource) {
        String directoryName;
        String directoryPath;
        JpsFileEntitySource jpsFileEntitySource = internalSource;
        if (jpsFileEntitySource instanceof JpsFileEntitySource.FileInDirectory) {
            directoryPath = VfsUtil.urlToPath((String)((JpsFileEntitySource.FileInDirectory)internalSource).getDirectory().getUrl());
            directoryName = PathUtil.getFileName((String)directoryPath);
        } else {
            throw (Throwable)new IllegalArgumentException("Unsupported internal entity source " + internalSource);
        }
        String parentPath = PathUtil.getParentPath((String)directoryPath);
        return Intrinsics.areEqual((Object)PathUtil.getFileName((String)parentPath), (Object)".idea") && (Intrinsics.areEqual((Object)directoryName, (Object)"libraries") || Intrinsics.areEqual((Object)directoryName, (Object)"artifacts")) ? (JpsFileEntitySource)new JpsFileEntitySource.ExactFile(VirtualFileUrlKt.append(this.getExternalStorageRoot(), "project/" + directoryName + ".xml"), this.projectLocation) : (JpsFileEntitySource)new JpsFileEntitySource.FileInDirectory(VirtualFileUrlKt.append(this.getExternalStorageRoot(), "modules"), this.projectLocation);
    }

    @Override
    @NotNull
    public VirtualFileUrl getExternalStorageRoot() {
        return this.externalStorageRoot;
    }

    public JpsExternalStorageMappingImpl(@NotNull VirtualFileUrl externalStorageRoot, @NotNull JpsProjectConfigLocation projectLocation) {
        this.externalStorageRoot = externalStorageRoot;
        this.projectLocation = projectLocation;
    }
}

