/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.util.ui.CollectionModelEditor;
import com.intellij.util.ui.ListItemEditor;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ListModelEditorBase<T>
extends CollectionModelEditor<T, ListItemEditor<T>> {
    protected final MyModel model = new MyModel();

    public ListModelEditorBase(@NotNull ListItemEditor<T> itemEditor) {
        super(itemEditor);
    }

    @NotNull
    public CollectionListModel<T> getModel() {
        return this.model;
    }

    @Override
    @NotNull
    protected List<T> getItems() {
        return this.model.items();
    }

    @Override
    public void reset(@NotNull List<? extends T> items) {
        super.reset(items);
        this.model.replaceAll(items);
    }

    public final void ensureNonEmptyNames(@NotNull String errorMessage) throws ConfigurationException {
        List<T> items = this.getItems();
        for (int i2 = items.size() - 1; i2 >= 0; --i2) {
            T item = items.get(i2);
            if (!StringUtil.isEmptyOrSpaces((String)((ListItemEditor)this.itemEditor).getName(item))) continue;
            if (((ListItemEditor)this.itemEditor).isEmpty(item)) {
                this.removeEmptyItem(i2);
                continue;
            }
            throw new ConfigurationException(errorMessage);
        }
    }

    protected void removeEmptyItem(int i2) {
    }

    @Override
    protected boolean isEditable(@NotNull T item) {
        return ((ListItemEditor)this.itemEditor).isEditable(item);
    }

    @NotNull
    public List<T> apply() {
        List<T> items = this.getItems();
        if (!this.helper.hasModifiedItems()) {
            return items;
        }
        this.helper.process((newItem, oldItem) -> {
            ((ListItemEditor)this.itemEditor).applyModifiedProperties(newItem, oldItem);
            this.silentlyReplaceItem(newItem, oldItem, -1);
            return true;
        });
        this.helper.reset(items);
        return items;
    }

    @Override
    protected void silentlyReplaceItem(@NotNull T oldItem, @NotNull T newItem, int index) {
        super.silentlyReplaceItem(oldItem, newItem, index);
        this.model.checkSelectionOnSilentReplace(oldItem, newItem);
    }

    protected final class MyModel
    extends MutableCollectionComboBoxModel<T> {
        protected MyModel() {
        }

        @NotNull
        final List<T> items() {
            return super.getInternalList();
        }

        void checkSelectionOnSilentReplace(@NotNull T oldItem, @NotNull T newItem) {
            if (this.mySelection == oldItem) {
                this.mySelection = newItem;
            }
        }

        protected void itemReplaced(@NotNull T existingItem, @Nullable T newItem) {
            ListModelEditorBase.this.helper.remove(existingItem);
        }

        public void removeAll() {
            super.removeAll();
            ListModelEditorBase.this.helper.reset(null);
        }
    }
}

