/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.perFileVersion;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistentSubIndexerVersionEnumerator<SubIndexerVersion>
implements Closeable {
    private static volatile int STORAGE_SIZE_LIMIT = 0x100000;
    @NotNull
    private final CachingEnumerator<SubIndexerVersion> myEnumerator;
    @NotNull
    private final File myFile;
    @NotNull
    private final KeyDescriptor<SubIndexerVersion> mySubIndexerTypeDescriptor;
    private volatile PersistentHashMap<SubIndexerVersion, Integer> myMap;
    private volatile int myNextVersion;
    private volatile int myWrittenNextVersion;

    public PersistentSubIndexerVersionEnumerator(@NotNull File file2, @NotNull KeyDescriptor<SubIndexerVersion> subIndexerTypeDescriptor) throws IOException {
        this.myFile = file2;
        this.mySubIndexerTypeDescriptor = subIndexerTypeDescriptor;
        this.myEnumerator = new CachingEnumerator((DataEnumerator)new MyEnumerator(), subIndexerTypeDescriptor);
        this.init();
        if (this.myNextVersion >= STORAGE_SIZE_LIMIT) {
            throw new IOException("Rebuild index due to attribute version enumerator overflow");
        }
    }

    public int enumerate(SubIndexerVersion version2) throws IOException {
        return this.myEnumerator.enumerate(version2);
    }

    public SubIndexerVersion valueOf(int idx) throws IOException {
        for (Object version2 : this.myMap.getAllKeysWithExistingMapping()) {
            Integer versionIdx = (Integer)this.myMap.get(version2);
            if (!Comparing.equal((Object)idx, (Object)versionIdx)) continue;
            return (SubIndexerVersion)version2;
        }
        return null;
    }

    private void init() throws IOException {
        this.myMap = new PersistentHashMap<SubIndexerVersion, Integer>(this.myFile, this.mySubIndexerTypeDescriptor, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE){};
        File nextVersionFile = PersistentSubIndexerVersionEnumerator.getNextVersionFile(this.myFile);
        String intValue = nextVersionFile.exists() ? FileUtil.loadFile((File)nextVersionFile, (Charset)StandardCharsets.UTF_8) : String.valueOf(1);
        try {
            this.myWrittenNextVersion = this.myNextVersion = Integer.parseInt(intValue);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid next version format " + intValue);
        }
    }

    public void clear() throws IOException {
        PersistentHashMap.deleteMap(this.myMap);
        this.init();
    }

    public void flush() throws IOException {
        this.myMap.force();
        this.writeNextVersion();
    }

    private void writeNextVersion() throws IOException {
        if (this.myNextVersion != this.myWrittenNextVersion) {
            FileUtil.writeToFile((File)PersistentSubIndexerVersionEnumerator.getNextVersionFile(this.myFile), (String)String.valueOf(this.myNextVersion));
            this.myWrittenNextVersion = this.myNextVersion;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.myMap.isClosed()) {
            this.myMap.close();
        }
        this.writeNextVersion();
    }

    @NotNull
    private static File getNextVersionFile(File baseFile) {
        return new File(baseFile.getAbsolutePath() + ".next");
    }

    public static void setStorageSizeLimit(int storageSizeLimit) {
        STORAGE_SIZE_LIMIT = storageSizeLimit;
    }

    public static int getStorageSizeLimit() {
        return STORAGE_SIZE_LIMIT;
    }

    private class MyEnumerator
    implements DataEnumerator<SubIndexerVersion> {
        private MyEnumerator() {
        }

        public synchronized int enumerate(@Nullable SubIndexerVersion value2) throws IOException {
            Integer val = (Integer)PersistentSubIndexerVersionEnumerator.this.myMap.get(value2);
            if (val != null) {
                return val;
            }
            PersistentSubIndexerVersionEnumerator.this.myMap.put(value2, (Object)(++PersistentSubIndexerVersionEnumerator.this.myNextVersion));
            if (PersistentSubIndexerVersionEnumerator.this.myNextVersion == Integer.MAX_VALUE) {
                throw new IOException("Request index rebuild");
            }
            return PersistentSubIndexerVersionEnumerator.this.myNextVersion;
        }

        @Nullable
        public SubIndexerVersion valueOf(int idx) {
            throw new UnsupportedOperationException();
        }
    }
}

