/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.forward;

import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class IntMapForwardIndex
implements IntForwardIndex {
    private final File myStorageFile;
    private final boolean myHasChunks;
    private volatile PersistentHashMap<Integer, Integer> myPersistentMap;

    public IntMapForwardIndex(@NotNull File storageFile, boolean hasChunks) throws IOException {
        this.myStorageFile = storageFile;
        this.myHasChunks = hasChunks;
        this.createMap();
    }

    private void createMap() throws IOException {
        Boolean old = (Boolean)PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.get();
        try {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(!this.myHasChunks);
            this.myPersistentMap = new PersistentHashMap<Integer, Integer>(this.myStorageFile.toPath(), (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)EnumeratorIntegerDescriptor.INSTANCE){

                protected boolean wantNonNegativeIntegralValues() {
                    return true;
                }
            };
        }
        catch (IOException e) {
            IOUtil.deleteAllFilesStartingWith((File)this.myStorageFile);
            throw e;
        }
        finally {
            PersistentHashMapValueStorage.CreationTimeOptions.HAS_NO_CHUNKS.set(old);
        }
    }

    public int getInt(@NotNull Integer key) throws IOException {
        assert (this.myPersistentMap != null);
        return (Integer)this.myPersistentMap.get((Object)key);
    }

    public void putInt(@NotNull Integer key, int value2) throws IOException {
        assert (this.myPersistentMap != null);
        this.myPersistentMap.put((Object)key, (Object)value2);
    }

    public void force() {
        if (this.myPersistentMap != null) {
            this.myPersistentMap.force();
        }
    }

    public void clear() throws IOException {
        PersistentHashMap.deleteMap(this.myPersistentMap);
        this.createMap();
    }

    public void close() throws IOException {
        if (this.myPersistentMap != null) {
            this.myPersistentMap.close();
        }
    }
}

