/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VfsEventsMerger {
    private static final boolean DEBUG = FileBasedIndexImpl.DO_TRACE_STUB_INDEX_UPDATE;
    private static final Logger LOG = Logger.getInstance(VfsEventsMerger.class);
    private final AtomicInteger myPublishedEventIndex = new AtomicInteger();
    private final ConcurrentIntObjectMap<ChangeInfo> myChangeInfos = ContainerUtil.createConcurrentIntObjectMap();
    private static final short FILE_ADDED = 1;
    private static final short FILE_REMOVED = 2;
    private static final short FILE_CONTENT_CHANGED = 4;
    private static final short BEFORE_FILE_CONTENT_CHANGED = 8;
    private static final short FILE_TRANSIENT_STATE_CHANGED = 16;

    VfsEventsMerger() {
    }

    void recordFileEvent(@NotNull VirtualFile file2, boolean contentChange) {
        if (DEBUG) {
            LOG.info("Request build indices for file:" + VfsEventsMerger.getFileIdOrPath(file2) + ", contentChange:" + contentChange);
        }
        this.updateChange(file2, contentChange ? (short)4 : 1);
    }

    void recordBeforeFileEvent(@NotNull VirtualFile file2, boolean contentChanged) {
        if (DEBUG) {
            LOG.info("Request invalidate indices for file:" + VfsEventsMerger.getFileIdOrPath(file2) + ", contentChange:" + contentChanged);
        }
        this.updateChange(file2, contentChanged ? (short)8 : 2);
    }

    void recordTransientStateChangeEvent(@NotNull VirtualFile file2) {
        if (DEBUG) {
            LOG.info("Transient state changed for file:" + VfsEventsMerger.getFileIdOrPath(file2));
        }
        this.updateChange(file2, (short)16);
    }

    int getPublishedEventIndex() {
        return this.myPublishedEventIndex.get();
    }

    private void updateChange(@NotNull VirtualFile file2, @EventMask short mask) {
        if (file2 instanceof VirtualFileWithId) {
            this.updateChange(((VirtualFileWithId)file2).getId(), file2, mask);
        }
    }

    private void updateChange(int fileId, @NotNull VirtualFile file2, @EventMask short mask) {
        ChangeInfo existingChangeInfo;
        ChangeInfo newChangeInfo;
        while (this.myChangeInfos.put(fileId, (Object)(newChangeInfo = new ChangeInfo(file2, mask, existingChangeInfo = (ChangeInfo)this.myChangeInfos.get(fileId)))) != existingChangeInfo) {
        }
        this.myPublishedEventIndex.incrementAndGet();
    }

    void applyMergedEvents(@NotNull VfsEventsMerger merger) {
        for (ChangeInfo info : merger.myChangeInfos.values()) {
            this.updateChange(info.getFileId(), info.file, info.eventMask);
        }
    }

    boolean processChanges(@NotNull VfsEventProcessor eventProcessor) {
        if (!this.myChangeInfos.isEmpty()) {
            int[] fileIds;
            for (int fileId : fileIds = this.myChangeInfos.keys()) {
                ProgressManager.checkCanceled();
                ChangeInfo info = (ChangeInfo)this.myChangeInfos.remove(fileId);
                if (info == null) continue;
                try {
                    if (DEBUG) {
                        System.out.println("Processing " + info);
                    }
                    if (!eventProcessor.process(info)) {
                        return false;
                    }
                }
                catch (ProcessCanceledException pce) {
                    FileBasedIndexImpl.LOG.error((Throwable)pce);
                    assert (false);
                }
            }
        }
        return true;
    }

    boolean hasChanges() {
        return !this.myChangeInfos.isEmpty();
    }

    int getApproximateChangesCount() {
        return this.myChangeInfos.size();
    }

    @NotNull
    Stream<VirtualFile> getChangedFiles() {
        return this.myChangeInfos.values().stream().map(ChangeInfo::getFile);
    }

    private static String getFileIdOrPath(@NotNull VirtualFile file2) {
        return file2 instanceof VirtualFileWithId ? String.valueOf(((VirtualFileWithId)file2).getId()) : file2.getPath();
    }

    static class ChangeInfo {
        private final VirtualFile file;
        @EventMask
        private final short eventMask;

        ChangeInfo(@NotNull VirtualFile file2, @EventMask short eventMask, @Nullable ChangeInfo previous) {
            this.file = file2;
            this.eventMask = ChangeInfo.mergeEventMask(previous == null ? (short)0 : previous.eventMask, eventMask);
        }

        @EventMask
        private static short mergeEventMask(@EventMask short existingOperation, @EventMask short newOperation) {
            if (newOperation == 2) {
                return 2;
            }
            return (short)(existingOperation | newOperation);
        }

        public String toString() {
            StringBuilder builder2 = new StringBuilder();
            builder2.append("file: ").append(this.file.getPath()).append("\n").append("operation: ");
            if ((this.eventMask & 0x10) != 0) {
                builder2.append("TRANSIENT_STATE_CHANGE ");
            }
            if ((this.eventMask & 8) != 0) {
                builder2.append("UPDATE-REMOVE ");
            }
            if ((this.eventMask & 4) != 0) {
                builder2.append("UPDATE ");
            }
            if ((this.eventMask & 2) != 0) {
                builder2.append("REMOVE ");
            }
            if ((this.eventMask & 1) != 0) {
                builder2.append("ADD ");
            }
            return builder2.toString().trim();
        }

        boolean isBeforeContentChanged() {
            return (this.eventMask & 8) != 0;
        }

        boolean isContentChanged() {
            return (this.eventMask & 4) != 0;
        }

        boolean isFileRemoved() {
            return (this.eventMask & 2) != 0;
        }

        boolean isFileAdded() {
            return (this.eventMask & 1) != 0;
        }

        boolean isTransientStateChanged() {
            return (this.eventMask & 0x10) != 0;
        }

        @NotNull
        VirtualFile getFile() {
            return this.file;
        }

        int getFileId() {
            int fileId = FileBasedIndexImpl.getIdMaskingNonIdBasedFile(this.file);
            if (fileId < 0) {
                fileId = -fileId;
            }
            return fileId;
        }
    }

    static @interface EventMask {
    }

    @FunctionalInterface
    public static interface VfsEventProcessor {
        public boolean process(@NotNull ChangeInfo var1);
    }
}

