/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ProjectTopics;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.impl.ProgressSuspender;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdaterImpl;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.PoweredProgressIndicator;
import com.intellij.util.indexing.UnindexedFilesFinder;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import com.intellij.util.indexing.diagnostic.FileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.IndexingJobStatistics;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.roots.IndexableFilesProvider;
import com.intellij.util.indexing.roots.SdkIndexableFilesProvider;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.progress.ConcurrentTasksProgressManager;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public final class UnindexedFilesUpdater
extends DumbModeTask {
    private static final Logger LOG = Logger.getInstance(UnindexedFilesUpdater.class);
    private static final int DEFAULT_MAX_INDEXER_THREADS = 4;
    public static final ExecutorService GLOBAL_INDEXING_EXECUTOR = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Indexing", (int)UnindexedFilesUpdater.getMaxNumberOfIndexingThreads());
    @NotNull
    private static final Key<Boolean> CONTENT_SCANNED = Key.create((String)"CONTENT_SCANNED");
    private final FileBasedIndexImpl myIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
    private final Project myProject;
    private final boolean myStartSuspended;
    private final boolean myRunExtensionsForFilesMarkedAsIndexed;
    private final PushedFilePropertiesUpdater myPusher;

    public UnindexedFilesUpdater(final @NotNull Project project, boolean startSuspended, boolean runExtensionsForFilesMarkedAsIndexed) {
        super((Object)project);
        this.myProject = project;
        this.myStartSuspended = startSuspended;
        this.myRunExtensionsForFilesMarkedAsIndexed = runExtensionsForFilesMarkedAsIndexed;
        this.myPusher = PushedFilePropertiesUpdater.getInstance((Project)this.myProject);
        project.getMessageBus().connect((Disposable)this).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                DumbService.getInstance((Project)project).cancelTask((DumbModeTask)UnindexedFilesUpdater.this);
            }
        });
        this.myProject.putUserData(CONTENT_SCANNED, null);
    }

    public UnindexedFilesUpdater(@NotNull Project project) {
        this(project, false, !UnindexedFilesUpdater.isProjectContentFullyScanned(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnindexedFiles(ProgressIndicator indicator) {
        if (!IndexInfrastructure.hasIndices()) {
            return;
        }
        ProjectIndexingHistory projectIndexingHistory = new ProjectIndexingHistory(this.myProject.getName());
        projectIndexingHistory.getTimes().setIndexingStart(Instant.now());
        if (this.myStartSuspended) {
            ProgressSuspender suspender = ProgressSuspender.getSuspender(indicator);
            if (suspender == null) {
                throw new IllegalStateException("Indexing progress indicator must be suspendable!");
            }
            if (!suspender.isSuspended()) {
                suspender.suspendProcess(IndexingBundle.message((String)"progress.indexing.started.as.suspended", (Object[])new Object[0]));
            }
        }
        indicator.setIndeterminate(true);
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        projectIndexingHistory.getTimes().setPushPropertiesStart(Instant.now());
        PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
        this.myPusher.pushAllPropertiesNow();
        boolean trackResponsiveness = !ApplicationManager.getApplication().isUnitTestMode();
        projectIndexingHistory.getTimes().setPushPropertiesEnd(Instant.now());
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Pushing properties");
        }
        this.myIndex.clearIndicesIfNecessary();
        snapshot = PerformanceWatcher.takeSnapshot();
        projectIndexingHistory.getTimes().setIndexExtensionsStart(Instant.now());
        FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.processIndexingProject(this.myProject, indicator));
        projectIndexingHistory.getTimes().setIndexExtensionsEnd(Instant.now());
        projectIndexingHistory.getTimes().setScanFilesStart(Instant.now());
        List<IndexableFilesProvider> orderedProviders = this.getOrderedProviders();
        Map<IndexableFilesProvider, List<VirtualFile>> providerToFiles = this.collectIndexableFilesConcurrently(this.myProject, indicator, orderedProviders);
        this.myProject.putUserData(CONTENT_SCANNED, (Object)true);
        projectIndexingHistory.getTimes().setScanFilesEnd(Instant.now());
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Indexable file iteration");
        }
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleInitialVfsRefresh();
        }
        int totalFiles = providerToFiles.values().stream().mapToInt(it -> it.size()).sum();
        if (trackResponsiveness) {
            LOG.info("Unindexed files update started: " + totalFiles + " files to index");
        }
        if (totalFiles == 0 || SystemProperties.getBooleanProperty((String)"idea.indexes.pretendNoFiles", (boolean)false)) {
            FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.noFilesFoundToProcessIndexingProject(this.myProject, indicator));
            return;
        }
        snapshot = PerformanceWatcher.takeSnapshot();
        ProgressIndicator poweredIndicator = PoweredProgressIndicator.wrap(indicator, UnindexedFilesUpdater.getPowerForSmoothProgressIndicator());
        poweredIndicator.setIndeterminate(false);
        poweredIndicator.setFraction(0.0);
        poweredIndicator.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(poweredIndicator, totalFiles);
        int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
        LOG.info("Using " + numberOfIndexingThreads + " " + StringUtil.pluralize((String)"thread", (int)numberOfIndexingThreads) + " for indexing");
        IndexUpdateRunner indexUpdateRunner = new IndexUpdateRunner(this.myIndex, GLOBAL_INDEXING_EXECUTOR, numberOfIndexingThreads);
        projectIndexingHistory.setNumberOfIndexingThreads(numberOfIndexingThreads);
        for (IndexableFilesProvider provider : orderedProviders) {
            List<VirtualFile> providerFiles = providerToFiles.get(provider);
            if (providerFiles == null || providerFiles.isEmpty()) continue;
            concurrentTasksProgressManager.setText(provider.getIndexingProgressText());
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(providerFiles.size());
            try {
                long startTime = System.nanoTime();
                IndexingJobStatistics indexStatistics = indexUpdateRunner.indexFiles(this.myProject, providerFiles, subTaskIndicator);
                long totalTime = System.nanoTime() - startTime;
                try {
                    FileProviderIndexStatistics statistics = new FileProviderIndexStatistics(provider.getDebugName(), providerFiles.size(), totalTime, indexStatistics);
                    projectIndexingHistory.addProviderStatistics(statistics);
                }
                catch (Exception e) {
                    LOG.error("Failed to add indexing statistics for " + provider.getDebugName(), (Throwable)e);
                }
            }
            finally {
                subTaskIndicator.finished();
            }
        }
        projectIndexingHistory.getTimes().setIndexingEnd(Instant.now());
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            NonUrgentExecutor.getInstance().execute(() -> IndexDiagnosticDumper.INSTANCE.dumpProjectIndexingHistoryToLogSubdirectory(projectIndexingHistory));
        }
        if (trackResponsiveness) {
            snapshot.logResponsivenessSinceCreation("Unindexed files update");
        }
        FileBasedIndexInfrastructureExtension.EP_NAME.extensions().forEach(ex -> ex.noFilesFoundToProcessIndexingProject(this.myProject, indicator));
        this.myIndex.dumpIndexStatistics();
    }

    static boolean isProjectContentFullyScanned(@NotNull Project project) {
        return Boolean.TRUE.equals(project.getUserData(CONTENT_SCANNED));
    }

    @NotNull
    private List<IndexableFilesProvider> getOrderedProviders() {
        List<IndexableFilesProvider> originalOrderedProviders = this.myIndex.getOrderedIndexableFilesProviders(this.myProject);
        ArrayList<IndexableFilesProvider> orderedProviders = new ArrayList<IndexableFilesProvider>();
        originalOrderedProviders.stream().filter(p -> !(p instanceof SdkIndexableFilesProvider)).collect(Collectors.toCollection(() -> orderedProviders));
        originalOrderedProviders.stream().filter(p -> p instanceof SdkIndexableFilesProvider).collect(Collectors.toCollection(() -> orderedProviders));
        return orderedProviders;
    }

    @NotNull
    private Map<IndexableFilesProvider, List<VirtualFile>> collectIndexableFilesConcurrently(@NotNull Project project, @NotNull ProgressIndicator indicator, @NotNull List<IndexableFilesProvider> providers) {
        if (providers.isEmpty()) {
            return Collections.emptyMap();
        }
        UnindexedFilesFinder unindexedFileFilter = new UnindexedFilesFinder(project, this.myIndex, this.myRunExtensionsForFilesMarkedAsIndexed);
        IdentityHashMap<IndexableFilesProvider, List<VirtualFile>> providerToFiles = new IdentityHashMap<IndexableFilesProvider, List<VirtualFile>>();
        ConcurrentBitSet visitedFileSet = new ConcurrentBitSet();
        indicator.setText(IndexingBundle.message((String)"progress.indexing.scanning", (Object[])new Object[0]));
        indicator.setIndeterminate(false);
        indicator.setFraction(0.0);
        ConcurrentTasksProgressManager concurrentTasksProgressManager = new ConcurrentTasksProgressManager(indicator, providers.size());
        List tasks = ContainerUtil.map(providers, provider -> {
            SubTaskProgressIndicator subTaskIndicator = concurrentTasksProgressManager.createSubTaskIndicator(1);
            ArrayList files2 = new ArrayList();
            providerToFiles.put((IndexableFilesProvider)provider, files2);
            ContentIterator collectingIterator = fileOrDir -> {
                if (subTaskIndicator.isCanceled()) {
                    return false;
                }
                if (unindexedFileFilter.accept(fileOrDir)) {
                    files2.add(fileOrDir);
                }
                return true;
            };
            return () -> {
                subTaskIndicator.setText(provider.getRootsScanningProgressText());
                try {
                    provider.iterateFiles(project, collectingIterator, visitedFileSet);
                }
                finally {
                    subTaskIndicator.finished();
                }
            };
        });
        PushedFilePropertiesUpdaterImpl.invokeConcurrentlyIfPossible(tasks);
        return providerToFiles;
    }

    private void scheduleInitialVfsRefresh() {
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).markRootsForRefresh();
        Application app = ApplicationManager.getApplication();
        if (!app.isCommandLine()) {
            final long sessionId = VirtualFileManager.getInstance().asyncRefresh(null);
            final MessageBusConnection connection = app.getMessageBus().connect();
            connection.subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosed(@NotNull Project project) {
                    if (project == UnindexedFilesUpdater.this.myProject) {
                        RefreshQueue.getInstance().cancelSession(sessionId);
                        connection.disconnect();
                    }
                }
            });
        } else {
            ApplicationManager.getApplication().invokeAndWait(() -> VirtualFileManager.getInstance().syncRefresh());
        }
    }

    private static double getPowerForSmoothProgressIndicator() {
        String rawValue = Registry.stringValue((String)"indexing.progress.indicator.power");
        if ("-".equals(rawValue)) {
            return 1.0;
        }
        try {
            return Double.parseDouble(rawValue);
        }
        catch (NumberFormatException e) {
            return 1.0;
        }
    }

    public void performInDumbMode(@NotNull ProgressIndicator indicator) {
        this.myIndex.filesUpdateStarted(this.myProject);
        try {
            this.updateUnindexedFiles(indicator);
        }
        catch (ProcessCanceledException e) {
            LOG.info("Unindexed files update canceled");
            throw e;
        }
        finally {
            this.myIndex.filesUpdateFinished(this.myProject);
        }
    }

    public static int getNumberOfIndexingThreads() {
        int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadsCount <= 0) {
            int coresToLeaveForOtherActivity = ApplicationManager.getApplication().isCommandLine() ? 0 : 1;
            threadsCount = Math.max(1, Math.min(Runtime.getRuntime().availableProcessors() - coresToLeaveForOtherActivity, 4));
        }
        return threadsCount;
    }

    public static int getMaxNumberOfIndexingThreads() {
        int threadsCount = Registry.intValue((String)"caches.indexerThreadsCount");
        if (threadsCount <= 0) {
            return 4;
        }
        return threadsCount;
    }
}

