/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;

class PoweredProgressIndicator
extends DelegatingProgressIndicator {
    private final double myPower;

    static ProgressIndicator wrap(@NotNull ProgressIndicator indicator, double power) {
        return new PoweredProgressIndicator(indicator, power);
    }

    private PoweredProgressIndicator(@NotNull ProgressIndicator indicator, double power) {
        super(indicator);
        this.myPower = power;
    }

    public void setFraction(double fraction) {
        double poweredFraction = Math.pow(fraction, this.myPower);
        super.setFraction(poweredFraction);
    }
}

