/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentBitSet;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LightDirectoryIndex<T> {
    private final Map<VirtualFile, T> myRootInfos = new ConcurrentHashMap<VirtualFile, T>();
    private final ConcurrentBitSet myNonInterestingIds = new ConcurrentBitSet();
    private final T myDefValue;
    private final Consumer<LightDirectoryIndex<T>> myInitializer;

    public LightDirectoryIndex(@NotNull Disposable parentDisposable, @NotNull T defValue, @NotNull Consumer<LightDirectoryIndex<T>> initializer) {
        this.myDefValue = defValue;
        this.myInitializer = initializer;
        this.resetIndex();
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect(parentDisposable);
        connection.subscribe(FileTypeManager.TOPIC, (Object)new FileTypeListener(){

            public void fileTypesChanged(@NotNull FileTypeEvent event) {
                LightDirectoryIndex.this.resetIndex();
            }
        });
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull List<? extends VFileEvent> events) {
                for (VFileEvent vFileEvent : events) {
                    if (!LightDirectoryIndex.shouldReset(vFileEvent)) continue;
                    LightDirectoryIndex.this.resetIndex();
                    break;
                }
            }
        });
    }

    private static boolean shouldReset(VFileEvent event) {
        if (event instanceof VFileCreateEvent) {
            return ((VFileCreateEvent)event).isDirectory();
        }
        VirtualFile file2 = event.getFile();
        return file2 == null || file2.isDirectory();
    }

    public void resetIndex() {
        this.myRootInfos.clear();
        this.myNonInterestingIds.clear();
        this.myInitializer.consume((Object)this);
    }

    public void putInfo(@Nullable VirtualFile file2, @NotNull T value2) {
        if (!(file2 instanceof VirtualFileWithId)) {
            return;
        }
        this.myRootInfos.put(file2, value2);
    }

    @NotNull
    public T getInfoForFile(@Nullable VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || !file2.isValid()) {
            return this.myDefValue;
        }
        for (VirtualFile each = file2; each != null; each = each.getParent()) {
            int id2 = ((VirtualFileWithId)each).getId();
            if (this.myNonInterestingIds.get(id2)) continue;
            T info = this.myRootInfos.get(each);
            if (info != null) {
                return info;
            }
            this.myNonInterestingIds.set(id2);
        }
        return this.myDefValue;
    }
}

