/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileBasedIndexInfrastructureExtension;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongProcedure;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IndexingStamp {
    private static final long INDEX_DATA_OUTDATED_STAMP = -2L;
    private static volatile int VERSION = -1;
    private static final int BASE_VERSION = 15;
    private static final ConcurrentMap<ID<?, ?>, IndexVersion> ourIndexIdToCreationStamp = new ConcurrentHashMap();
    private static final long ourVfsCreationStamp = FSRecords.getCreationTimestamp();
    static final int INVALID_FILE_ID = 0;
    private static final int MIN_FS_MODIFIED_TIMESTAMP_RESOLUTION = 2000;
    private static final int OUR_INDICES_TIMESTAMP_INCREMENT = SystemProperties.getIntProperty((String)"idea.indices.timestamp.resolution", (int)1);
    private static final IndexVersion NON_EXISTING_INDEX_VERSION = new IndexVersion(0L, -1, -1L);
    private static final IntObjectMap<Timestamps> myTimestampsCache = ContainerUtil.createConcurrentIntObjectMap();
    private static final BlockingQueue<Integer> ourFinishedFiles = new ArrayBlockingQueue<Integer>(100);
    private static final ReadWriteLock[] ourLocks = new ReadWriteLock[16];

    private IndexingStamp() {
    }

    static void initPersistentIndexStamp(DataInput in) throws IOException {
        IndexVersion.advanceIndexStamp(DataInputOutputUtil.readTIME((DataInput)in));
    }

    static void savePersistentIndexStamp(DataOutput out) throws IOException {
        DataInputOutputUtil.writeTIME((DataOutput)out, (long)IndexVersion.ourLastStamp);
    }

    private static int getVersion() {
        if (VERSION == -1) {
            int version2 = 15;
            for (FileBasedIndexInfrastructureExtension ex : (FileBasedIndexInfrastructureExtension[])FileBasedIndexInfrastructureExtension.EP_NAME.getExtensions()) {
                version2 = 31 * version2 + ex.getVersion();
            }
            VERSION = version2;
        }
        return VERSION;
    }

    static void clearCachedIndexVersions() {
        VERSION = -1;
        ourIndexIdToCreationStamp.clear();
    }

    public static synchronized void rewriteVersion(@NotNull ID<?, ?> indexId, int version2) throws IOException {
        if (FileBasedIndex.USE_IN_MEMORY_INDEX) {
            return;
        }
        final File file2 = IndexInfrastructure.getVersionFile(indexId);
        if (FileBasedIndexImpl.LOG.isDebugEnabled()) {
            FileBasedIndexImpl.LOG.debug("Rewriting " + file2 + "," + version2);
        }
        IndexVersion newIndexVersion = IndexingStamp.getIndexVersion(indexId).nextVersion(version2, FSRecords.getCreationTimestamp());
        if (file2.exists()) {
            FileUtil.deleteWithRenaming((File)file2);
        } else {
            file2.getParentFile().mkdirs();
        }
        try (DataOutputStream os = (DataOutputStream)FileUtilRt.doIOOperation((FileUtilRt.RepeatableIOOperation)new FileUtilRt.RepeatableIOOperation<DataOutputStream, FileNotFoundException>(){

            @Nullable
            public DataOutputStream execute(boolean lastAttempt) throws FileNotFoundException {
                try {
                    return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file2)));
                }
                catch (FileNotFoundException ex) {
                    if (lastAttempt) {
                        throw ex;
                    }
                    return null;
                }
            }
        });){
            assert (os != null);
            newIndexVersion.write(os);
            ourIndexIdToCreationStamp.put(indexId, newIndexVersion);
        }
    }

    public static IndexVersionDiff versionDiffers(@NotNull ID<?, ?> indexId, int currentIndexVersion) {
        IndexVersion version2 = IndexingStamp.getIndexVersion(indexId);
        if (version2.myIndexVersion == -1) {
            return new IndexVersionDiff.InitialBuild(currentIndexVersion);
        }
        if (version2.myIndexVersion != currentIndexVersion) {
            return new IndexVersionDiff.VersionChanged(version2.myIndexVersion, currentIndexVersion, "index version");
        }
        if (version2.myCommonIndicesVersion != IndexingStamp.getVersion()) {
            return new IndexVersionDiff.VersionChanged(version2.myCommonIndicesVersion, IndexingStamp.getVersion(), "common index version");
        }
        if (version2.myVfsCreationStamp != ourVfsCreationStamp) {
            return new IndexVersionDiff.VersionChanged(version2.myVfsCreationStamp, ourVfsCreationStamp, "vfs creation stamp");
        }
        return IndexVersionDiff.UP_TO_DATE;
    }

    public static long getIndexCreationStamp(@NotNull ID<?, ?> indexName) {
        IndexVersion version2 = IndexingStamp.getIndexVersion(indexName);
        return version2.myModificationCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static IndexVersion getIndexVersion(@NotNull ID<?, ?> indexName) {
        IndexVersion version2 = (IndexVersion)ourIndexIdToCreationStamp.get(indexName);
        if (version2 != null) {
            return version2;
        }
        Class<IndexingStamp> clazz = IndexingStamp.class;
        synchronized (IndexingStamp.class) {
            version2 = (IndexVersion)ourIndexIdToCreationStamp.get(indexName);
            if (version2 != null) {
                // ** MonitorExit[clazz] (shouldn't be in output)
                return version2;
            }
            File versionFile = IndexInfrastructure.getVersionFile(indexName);
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(versionFile)));){
                version2 = new IndexVersion(in);
                ourIndexIdToCreationStamp.put(indexName, version2);
                IndexVersion indexVersion = version2;
                // ** MonitorExit[clazz] (shouldn't be in output)
                return indexVersion;
            }
            catch (IOException iOException) {
                version2 = NON_EXISTING_INDEX_VERSION;
                ourIndexIdToCreationStamp.put(indexName, version2);
                // ** MonitorExit[clazz] (shouldn't be in output)
                return version2;
            }
        }
    }

    public static FileIndexingState isFileIndexedStateCurrent(int fileId, ID<?, ?> indexName) {
        try {
            long stamp = IndexingStamp.getIndexStamp(fileId, indexName);
            if (stamp == 0L) {
                return FileIndexingState.NOT_INDEXED;
            }
            return stamp == IndexingStamp.getIndexCreationStamp(indexName) ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (!(cause instanceof IOException)) {
                throw e;
            }
            return FileIndexingState.OUT_DATED;
        }
    }

    public static void setFileIndexedStateCurrent(int fileId, ID<?, ?> id2) {
        IndexingStamp.update(fileId, id2, IndexingStamp.getIndexCreationStamp(id2));
    }

    public static void setFileIndexedStateOutdated(int fileId, ID<?, ?> id2) {
        IndexingStamp.update(fileId, id2, -2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getIndexStamp(int fileId, ID<?, ?> indexName) {
        Lock readLock = IndexingStamp.getStripedLock(fileId).readLock();
        readLock.lock();
        try {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            if (stamp != null) {
                long l = stamp.get(indexName);
                return l;
            }
            long l = 0L;
            return l;
        }
        finally {
            readLock.unlock();
        }
    }

    public static void dropIndexingTimeStamps(int fileId) throws IOException {
        myTimestampsCache.remove(fileId);
        try (com.intellij.util.io.DataOutputStream out = FSRecords.writeAttribute(fileId, Timestamps.PERSISTENCE);){
            new Timestamps(null).writeToStream((DataOutputStream)out);
        }
    }

    private static Timestamps createOrGetTimeStamp(int id2) {
        Timestamps timestamps;
        boolean isValid;
        boolean bl = isValid = id2 > 0;
        if (!isValid) {
            id2 = -id2;
        }
        if ((timestamps = (Timestamps)myTimestampsCache.get(id2)) == null) {
            try (DataInputStream stream = FSRecords.readAttributeWithLock(id2, Timestamps.PERSISTENCE);){
                timestamps = new Timestamps(stream);
            }
            catch (IOException e) {
                FSRecords.handleError(e);
                throw new RuntimeException(e);
            }
            if (isValid) {
                myTimestampsCache.put(id2, (Object)timestamps);
            }
        }
        return timestamps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(int fileId, @NotNull ID<?, ?> indexName, long indexCreationStamp) {
        if (fileId < 0 || fileId == 0) {
            return;
        }
        Lock writeLock = IndexingStamp.getStripedLock(fileId).writeLock();
        writeLock.lock();
        try {
            Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
            if (stamp != null) {
                stamp.set(indexName, indexCreationStamp);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<ID<?, ?>> getNontrivialFileIndexedStates(int fileId) {
        if (fileId != 0) {
            Lock readLock = IndexingStamp.getStripedLock(fileId).readLock();
            readLock.lock();
            try {
                Timestamps stamp = IndexingStamp.createOrGetTimeStamp(fileId);
                if (stamp != null && stamp.myIndexStamps != null && !stamp.myIndexStamps.isEmpty()) {
                    SmartList retained = new SmartList();
                    stamp.myIndexStamps.forEach(object -> {
                        retained.add(object);
                        return true;
                    });
                    SmartList smartList = retained;
                    return smartList;
                }
            }
            catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
            }
            finally {
                readLock.unlock();
            }
        }
        return Collections.emptyList();
    }

    public static void flushCaches() {
        IndexingStamp.flushCache(null);
    }

    public static void flushCache(@Nullable Integer finishedFile) {
        if (finishedFile != null && finishedFile == 0) {
            finishedFile = 0;
        }
        while (finishedFile == null || !ourFinishedFiles.offer(finishedFile)) {
            ArrayList files2 = new ArrayList(ourFinishedFiles.size());
            ourFinishedFiles.drainTo(files2);
            if (!files2.isEmpty()) {
                for (Integer file2 : files2) {
                    Lock writeLock = IndexingStamp.getStripedLock(file2).writeLock();
                    writeLock.lock();
                    try {
                        Timestamps timestamp = (Timestamps)myTimestampsCache.remove(file2.intValue());
                        if (timestamp == null || !timestamp.isDirty()) continue;
                        com.intellij.util.io.DataOutputStream sink = FSRecords.writeAttribute(file2, Timestamps.PERSISTENCE);
                        Throwable throwable = null;
                        try {
                            timestamp.writeToStream((DataOutputStream)sink);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (sink == null) continue;
                            if (throwable != null) {
                                try {
                                    sink.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            sink.close();
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
            }
            if (finishedFile != null) continue;
            break;
        }
    }

    private static ReadWriteLock getStripedLock(int fileId) {
        if (fileId < 0) {
            fileId = -fileId;
        }
        return ourLocks[(fileId & 0xFF) % ourLocks.length];
    }

    static {
        for (int i2 = 0; i2 < ourLocks.length; ++i2) {
            IndexingStamp.ourLocks[i2] = new ReentrantReadWriteLock();
        }
    }

    private static class Timestamps {
        private static final FileAttribute PERSISTENCE = new FileAttribute("__index_stamps__", 2, false);
        private TObjectLongHashMap<ID<?, ?>> myIndexStamps;
        private boolean myIsDirty = false;

        private Timestamps(@Nullable DataInputStream stream) throws IOException {
            if (stream != null) {
                int[] outdatedIndices = null;
                long dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                long diff = dominatingIndexStamp - 1040688000000L;
                if (diff > 0L && diff < 32767L) {
                    int numberOfOutdatedIndices = (int)diff;
                    outdatedIndices = new int[numberOfOutdatedIndices];
                    while (numberOfOutdatedIndices > 0) {
                        outdatedIndices[--numberOfOutdatedIndices] = DataInputOutputUtil.readINT((DataInput)stream);
                    }
                    dominatingIndexStamp = DataInputOutputUtil.readTIME((DataInput)stream);
                }
                while (stream.available() > 0) {
                    long stamp;
                    ID id2 = ID.findById((int)DataInputOutputUtil.readINT((DataInput)stream));
                    if (id2 == null || id2 instanceof StubIndexKey || (stamp = IndexingStamp.getIndexCreationStamp(id2)) == 0L) continue;
                    if (this.myIndexStamps == null) {
                        this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                    }
                    if (stamp > dominatingIndexStamp) continue;
                    this.myIndexStamps.put((Object)id2, stamp);
                }
                if (outdatedIndices != null) {
                    for (int outdatedIndexId : outdatedIndices) {
                        ID id3 = ID.findById((int)outdatedIndexId);
                        if (id3 == null || id3 instanceof StubIndexKey || IndexingStamp.getIndexCreationStamp(id3) == 0L) continue;
                        long stamp = -2L;
                        if (this.myIndexStamps == null) {
                            this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
                        }
                        if (stamp > dominatingIndexStamp) continue;
                        this.myIndexStamps.put((Object)id3, stamp);
                    }
                }
            }
        }

        private void writeToStream(final DataOutputStream stream) throws IOException {
            if (this.myIndexStamps != null && !this.myIndexStamps.isEmpty()) {
                final long[] data2 = new long[2];
                boolean dominatingStampIndex = false;
                boolean numberOfOutdatedIndex = true;
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> a, long b) {
                        if (b == -2L) {
                            data2[1] = data2[1] + 1L;
                            b = IndexingStamp.getIndexCreationStamp(a);
                        }
                        data2[0] = Math.max(data2[0], b);
                        return true;
                    }
                });
                if (data2[1] > 0L) {
                    assert (data2[1] < 32767L);
                    DataInputOutputUtil.writeTIME((DataOutput)stream, (long)(1040688000000L + data2[1]));
                    this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                        public boolean execute(ID<?, ?> id2, long timestamp) {
                            try {
                                if (timestamp == -2L) {
                                    DataInputOutputUtil.writeINT((DataOutput)stream, (int)id2.getUniqueId());
                                }
                                return true;
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    });
                }
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)data2[0]);
                this.myIndexStamps.forEachEntry(new TObjectLongProcedure<ID<?, ?>>(){

                    public boolean execute(ID<?, ?> id2, long timestamp) {
                        try {
                            if (timestamp == -2L) {
                                return true;
                            }
                            DataInputOutputUtil.writeINT((DataOutput)stream, (int)id2.getUniqueId());
                            return true;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            } else {
                DataInputOutputUtil.writeTIME((DataOutput)stream, (long)1040688000000L);
            }
        }

        private long get(ID<?, ?> id2) {
            return this.myIndexStamps != null ? this.myIndexStamps.get(id2) : 0L;
        }

        private void set(ID<?, ?> id2, long tmst) {
            if (this.myIndexStamps == null) {
                this.myIndexStamps = new TObjectLongHashMap(5, 0.98f);
            }
            if (tmst == -2L && !this.myIndexStamps.contains(id2)) {
                return;
            }
            long previous = this.myIndexStamps.put(id2, tmst);
            if (previous != tmst) {
                this.myIsDirty = true;
            }
        }

        public boolean isDirty() {
            return this.myIsDirty;
        }
    }

    public static interface IndexVersionDiff {
        public static final IndexVersionDiff UP_TO_DATE = new IndexVersionDiff(){

            @Override
            @NotNull
            public String getLogText() {
                return "";
            }
        };

        @NotNull
        public String getLogText();

        public static class VersionChanged
        implements IndexVersionDiff {
            private final long myPreviousVersion;
            private final long myActualVersion;
            private final String myVersionType;

            public VersionChanged(long previousVersion, long actualVersion, String type) {
                this.myPreviousVersion = previousVersion;
                this.myActualVersion = actualVersion;
                this.myVersionType = type;
            }

            @Override
            @NotNull
            public String getLogText() {
                return "(" + this.myVersionType + " : " + this.myPreviousVersion + " -> " + this.myActualVersion + ")";
            }
        }

        public static class CorruptedRebuild
        implements IndexVersionDiff {
            private final int myVersion;

            public CorruptedRebuild(int version2) {
                this.myVersion = version2;
            }

            @Override
            @NotNull
            public String getLogText() {
                return "(corrupted, v = " + this.myVersion + ")";
            }
        }

        public static class InitialBuild
        implements IndexVersionDiff {
            private final int myVersion;

            public InitialBuild(int version2) {
                this.myVersion = version2;
            }

            @Override
            @NotNull
            public String getLogText() {
                return "(v = " + this.myVersion + ")";
            }
        }
    }

    static class IndexVersion {
        private static volatile long ourLastStamp;
        final long myModificationCount;
        final int myIndexVersion;
        final int myCommonIndicesVersion;
        final long myVfsCreationStamp;

        private IndexVersion(long modificationCount, int indexVersion, long vfsCreationStamp) {
            this.myModificationCount = modificationCount;
            IndexVersion.advanceIndexStamp(modificationCount);
            this.myIndexVersion = indexVersion;
            this.myCommonIndicesVersion = IndexingStamp.getVersion();
            this.myVfsCreationStamp = vfsCreationStamp;
        }

        private static void advanceIndexStamp(long modificationCount) {
            ourLastStamp = Math.max(modificationCount, ourLastStamp);
        }

        IndexVersion(DataInput in) throws IOException {
            this.myIndexVersion = DataInputOutputUtil.readINT((DataInput)in);
            this.myCommonIndicesVersion = DataInputOutputUtil.readINT((DataInput)in);
            this.myVfsCreationStamp = DataInputOutputUtil.readTIME((DataInput)in);
            this.myModificationCount = DataInputOutputUtil.readTIME((DataInput)in);
            IndexVersion.advanceIndexStamp(this.myModificationCount);
        }

        void write(DataOutput os) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)os, (int)this.myIndexVersion);
            DataInputOutputUtil.writeINT((DataOutput)os, (int)this.myCommonIndicesVersion);
            DataInputOutputUtil.writeTIME((DataOutput)os, (long)this.myVfsCreationStamp);
            DataInputOutputUtil.writeTIME((DataOutput)os, (long)this.myModificationCount);
        }

        IndexVersion nextVersion(int indexVersion, long vfsCreationStamp) {
            long modificationCount = IndexVersion.calcNextVersion(this == NON_EXISTING_INDEX_VERSION ? ourLastStamp : this.myModificationCount);
            return new IndexVersion(modificationCount, indexVersion, vfsCreationStamp);
        }

        private static long calcNextVersion(long modificationCount) {
            return Math.max(System.currentTimeMillis(), Math.max(modificationCount + 2000L, ourLastStamp + (long)OUR_INDICES_TIMESTAMP_INCREMENT));
        }
    }
}

