/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SubstitutedFileType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IndexedFileImpl
extends UserDataHolderBase
implements IndexedFile {
    protected final VirtualFile myFile;
    protected final String myFileName;
    private volatile Project myProject;
    private FileType mySubstituteFileType;
    @NotNull
    private final FileType myType;

    public IndexedFileImpl(@NotNull VirtualFile file2, Project project) {
        this(file2, file2.getFileType(), project);
    }

    public IndexedFileImpl(@NotNull VirtualFile file2, @NotNull FileType type, Project project) {
        this.myFile = file2;
        this.myFileName = file2.getName();
        this.myProject = project;
        this.myType = type;
    }

    @NotNull
    public FileType getFileType() {
        if (this.mySubstituteFileType == null) {
            this.mySubstituteFileType = SubstitutedFileType.substituteFileType(this.myFile, this.myType, this.getProject());
        }
        return this.mySubstituteFileType;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public String getFileName() {
        return this.myFileName;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public String toString() {
        return "IndexedFileImpl(" + this.getFileName() + ")";
    }
}

