/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;

public class IndexAccessValidator {
    private final ThreadLocal<ID<?, ?>> ourAlreadyProcessingIndices = new ThreadLocal();

    private void checkAccessingIndexDuringOtherIndexProcessing(@NotNull ID<?, ?> indexKey) {
        ID<?, ?> alreadyProcessingIndex = this.ourAlreadyProcessingIndices.get();
        if (alreadyProcessingIndex != null && alreadyProcessingIndex != indexKey) {
            String message = MessageFormat.format("Accessing ''{0}'' during processing ''{1}''. Nested different indices processing may cause deadlock", indexKey.getName(), alreadyProcessingIndex.getName());
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new RuntimeException(message);
            }
            Logger.getInstance(FileBasedIndexImpl.class).error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Throwable> T validate(@NotNull ID<?, ?> indexKey, @NotNull ThrowableComputable<T, E> runnable2) throws E {
        this.checkAccessingIndexDuringOtherIndexProcessing(indexKey);
        this.ourAlreadyProcessingIndices.set(indexKey);
        try {
            Object object = runnable2.compute();
            return (T)object;
        }
        finally {
            this.ourAlreadyProcessingIndices.set(null);
        }
    }
}

