/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IdFilter;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSymbolParameters {
    private final String myCompletePattern;
    private final String myLocalPatternName;
    private final GlobalSearchScope mySearchScope;
    private final IdFilter myIdFilter;

    public FindSymbolParameters(@NotNull String pattern, @NotNull String name, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        this.myCompletePattern = pattern;
        this.myLocalPatternName = name;
        this.mySearchScope = scope;
        this.myIdFilter = idFilter;
    }

    public FindSymbolParameters withCompletePattern(@NotNull String pattern) {
        return new FindSymbolParameters(pattern, this.myLocalPatternName, this.mySearchScope, this.myIdFilter);
    }

    public FindSymbolParameters withLocalPattern(@NotNull String pattern) {
        return new FindSymbolParameters(this.myCompletePattern, pattern, this.mySearchScope, this.myIdFilter);
    }

    public FindSymbolParameters withScope(@NotNull GlobalSearchScope scope) {
        return new FindSymbolParameters(this.myCompletePattern, this.myLocalPatternName, scope, this.myIdFilter);
    }

    @NotNull
    public String getCompletePattern() {
        return this.myCompletePattern;
    }

    @NotNull
    public String getLocalPatternName() {
        return this.myLocalPatternName;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @Nullable
    public IdFilter getIdFilter() {
        return this.myIdFilter;
    }

    @NotNull
    public Project getProject() {
        return Objects.requireNonNull(this.mySearchScope.getProject());
    }

    public boolean isSearchInLibraries() {
        return this.mySearchScope.isSearchInLibraries();
    }

    public static FindSymbolParameters wrap(@NotNull String pattern, @NotNull Project project, boolean searchInLibraries) {
        return new FindSymbolParameters(pattern, pattern, FindSymbolParameters.searchScopeFor(project, searchInLibraries), ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project));
    }

    public static FindSymbolParameters wrap(@NotNull String pattern, @NotNull GlobalSearchScope scope) {
        return new FindSymbolParameters(pattern, pattern, scope, null);
    }

    public static FindSymbolParameters simple(@NotNull Project project, boolean searchInLibraries) {
        return new FindSymbolParameters("", "", FindSymbolParameters.searchScopeFor(project, searchInLibraries), ((FileBasedIndexImpl)FileBasedIndex.getInstance()).projectIndexableFiles(project));
    }

    @NotNull
    public static GlobalSearchScope searchScopeFor(@Nullable Project project, boolean searchInLibraries) {
        return project == null ? new EverythingGlobalScope() : (searchInLibraries ? ProjectScope.getAllScope((Project)project) : ProjectScope.getProjectScope((Project)project));
    }
}

