/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.lang.FileASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LighterAST;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DefaultProjectFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.IndexedFileImpl;
import com.intellij.util.indexing.IndexingDataKeys;
import com.intellij.util.indexing.PsiDependentFileContent;
import com.intellij.util.indexing.SubstitutedFileType;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileContentImpl
extends IndexedFileImpl
implements PsiDependentFileContent {
    private Charset myCharset;
    protected byte[] myContent;
    private CharSequence myContentAsText;
    private final long myStamp;
    private byte[] myFileContentHash;
    private boolean myLighterASTShouldBeThreadSafe;
    private final boolean myPhysicalContent;
    private static final Key<PsiFile> CACHED_PSI = Key.create((String)"cached psi from content");

    public FileContentImpl(@NotNull VirtualFile file2, @NotNull CharSequence contentAsText, long documentStamp) {
        this(file2, contentAsText, null, documentStamp, false);
    }

    public FileContentImpl(@NotNull VirtualFile file2, byte @NotNull [] content2) {
        this(file2, null, content2, -1L, true);
    }

    protected FileContentImpl(@NotNull VirtualFile file2, CharSequence contentAsText, byte[] content2, long stamp, boolean physicalContent) {
        super(file2, FileTypeRegistry.getInstance().getFileTypeByFile(file2, content2), null);
        this.myContentAsText = contentAsText;
        this.myContent = content2;
        this.myStamp = stamp;
        this.myPhysicalContent = physicalContent;
    }

    @NotNull
    public PsiFile getPsiFile() {
        return this.getPsiFileForPsiDependentIndex();
    }

    @NotNull
    private PsiFile getFileFromText() {
        PsiFile psi = (PsiFile)this.getUserData(IndexingDataKeys.PSI_FILE);
        if (psi == null) {
            psi = (PsiFile)this.getUserData(CACHED_PSI);
        }
        if (psi == null) {
            psi = this.createFileFromText(this.getContentAsText());
            psi.putUserData(IndexingDataKeys.VIRTUAL_FILE, (Object)this.getFile());
            this.putUserData(CACHED_PSI, psi);
        }
        return psi;
    }

    @NotNull
    public LighterAST getLighterAST() {
        LighterAST lighterAST = (LighterAST)this.getUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY);
        if (lighterAST == null) {
            FileASTNode node = this.getPsiFile().getNode();
            lighterAST = this.myLighterASTShouldBeThreadSafe ? new TreeBackedLighterAST(node) : node.getLighterAST();
            this.putUserData(IndexingDataKeys.LIGHTER_AST_NODE_KEY, lighterAST);
        }
        return lighterAST;
    }

    void ensureThreadSafeLighterAST() {
        this.myLighterASTShouldBeThreadSafe = true;
    }

    public PsiFile createFileFromText(@NotNull CharSequence text) {
        FileType fileType;
        Project project = this.getProject();
        if (project == null) {
            project = DefaultProjectFactory.getInstance().getDefaultProject();
        }
        if (!((fileType = this.getFileTypeWithoutSubstitution()) instanceof LanguageFileType)) {
            throw new AssertionError((Object)("PSI can be created only for a file with LanguageFileType but actual is " + fileType.getClass() + ".\nPlease use a proper FileBasedIndexExtension#getInputFilter() implementation for the caller index"));
        }
        return FileContentImpl.createFileFromText(project, text, (LanguageFileType)fileType, this.myFile, this.myFileName);
    }

    @NotNull
    public static PsiFile createFileFromText(@NotNull Project project, @NotNull CharSequence text, @NotNull LanguageFileType fileType, @NotNull VirtualFile file2, @NotNull String fileName) {
        Language language = fileType.getLanguage();
        Language substitutedLanguage = LanguageSubstitutors.getInstance().substituteLanguage(language, file2, project);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText(fileName, substitutedLanguage, text, false, false, false, file2);
        if (psiFile == null) {
            throw new IllegalStateException("psiFile is null. language = " + language.getID() + ", substitutedLanguage = " + substitutedLanguage.getID());
        }
        return psiFile;
    }

    public static FileContent createByFile(@NotNull VirtualFile file2) throws IOException {
        return FileContentImpl.createByFile(file2, null);
    }

    public static FileContent createByFile(@NotNull VirtualFile file2, @Nullable Project project) throws IOException {
        FileContentImpl content2 = new FileContentImpl(file2, file2.contentsToByteArray());
        if (project != null) {
            content2.setProject(project);
        }
        return content2;
    }

    @ApiStatus.Internal
    @NotNull
    public FileType getFileTypeWithoutSubstitution() {
        FileType fileType = this.getFileType();
        return fileType instanceof SubstitutedFileType ? ((SubstitutedFileType)fileType).getOriginalFileType() : fileType;
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    @NotNull
    public String getFileName() {
        return this.myFileName;
    }

    @NotNull
    public Charset getCharset() {
        Charset charset = this.myCharset;
        if (charset == null) {
            this.myCharset = charset = this.myFile.getCharset();
        }
        return charset;
    }

    public long getStamp() {
        return this.myStamp;
    }

    public boolean isPhysicalContent() {
        return this.myPhysicalContent;
    }

    public byte @NotNull [] getContent() {
        byte[] content2 = this.myContent;
        if (content2 == null) {
            this.myContent = content2 = this.myContentAsText.toString().getBytes(this.getCharset());
        }
        return content2;
    }

    @NotNull
    public CharSequence getContentAsText() {
        FileType unsubstitutedFileType = this.getFileTypeWithoutSubstitution();
        if (unsubstitutedFileType.isBinary()) {
            throw new IllegalDataException("Cannot obtain text for binary file type : " + unsubstitutedFileType.getDescription());
        }
        CharSequence content2 = (CharSequence)this.getUserData(IndexingDataKeys.FILE_TEXT_CONTENT_KEY);
        if (content2 != null) {
            return content2;
        }
        CharSequence contentAsText = this.myContentAsText;
        if (contentAsText == null) {
            this.myContentAsText = contentAsText = LoadTextUtil.getTextByBinaryPresentation(this.myContent, this.myFile);
            this.myContent = null;
        }
        return contentAsText;
    }

    @Override
    public String toString() {
        return "FileContentImpl(" + this.getFileName() + ")";
    }

    public byte @Nullable [] getHash() {
        if (!this.myPhysicalContent) {
            throw new IllegalStateException("Hashes are allowed only while physical changes indexing");
        }
        return this.myFileContentHash;
    }

    public void setHashes(byte @NotNull [] fileContentHash) {
        this.myFileContentHash = fileContentHash;
    }

    @Deprecated
    @NotNull
    public PsiFile getPsiFileForPsiDependentIndex() {
        PsiFile existingPsi;
        PsiDocumentManager psiDocumentManager;
        Document document;
        PsiFile psi = null;
        if (!this.myPhysicalContent && (document = FileDocumentManager.getInstance().getCachedDocument(this.getFile())) != null && (psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject())).isUncommited(document) && (existingPsi = psiDocumentManager.getPsiFile(document)) != null) {
            psi = existingPsi;
        }
        if (psi == null) {
            psi = this.getFileFromText();
        }
        return psi;
    }

    @Override
    public Project getProject() {
        Project project = super.getProject();
        return project != null ? project : (Project)this.getUserData(IndexingDataKeys.PROJECT);
    }

    public static class IllegalDataException
    extends RuntimeException {
        IllegalDataException(String message) {
            super(message);
        }
    }
}

