/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.PersistentIndicesConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/util/indexing/CorruptionMarker;", "", "()V", "CORRUPTION_MARKER_NAME", "", "invalidateIndexesIfNeeded", "", "requestInvalidation", "", "intellij.platform.lang.impl"})
public final class CorruptionMarker {
    private static final String CORRUPTION_MARKER_NAME = "corruption.marker";
    public static final CorruptionMarker INSTANCE;

    @JvmStatic
    public static final void requestInvalidation() {
        File indexRoot = PathManager.getIndexRoot();
        FileBasedIndexImpl.LOG.info("Requesting explicit indices invalidation");
        try {
            File corruptionMarker = new File(indexRoot, CORRUPTION_MARKER_NAME);
            new FileOutputStream(corruptionMarker).close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @JvmStatic
    public static final boolean invalidateIndexesIfNeeded() {
        boolean corrupted;
        File indexRoot = PathManager.getIndexRoot();
        File corruptionMarker = new File(indexRoot, CORRUPTION_MARKER_NAME);
        boolean bl = corrupted = IndexInfrastructure.hasIndices() && corruptionMarker.exists();
        if (corrupted) {
            FileUtil.deleteWithRenaming((File)indexRoot);
            indexRoot.mkdirs();
            SerializationManagerEx.getInstanceEx().reinitializeNameStorage();
            ID.reinitializeDiskStorage();
            PersistentIndicesConfiguration.saveConfiguration();
            FileUtil.delete((File)corruptionMarker);
        }
        return corrupted;
    }

    private CorruptionMarker() {
    }

    static {
        CorruptionMarker corruptionMarker;
        INSTANCE = corruptionMarker = new CorruptionMarker();
    }
}

