/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.graph.impl;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Chunk;
import com.intellij.util.containers.Stack;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.graph.impl.CycleFinder;
import com.intellij.util.graph.impl.KShortestPathsFinder;
import com.intellij.util.graph.impl.ShortestPathFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphAlgorithmsImpl
extends GraphAlgorithms {
    public <Node> List<Node> findShortestPath(@NotNull Graph<Node> graph2, @NotNull Node start2, @NotNull Node finish) {
        return this.findShortestPath((InboundSemiGraph<Node>)graph2, start2, finish);
    }

    @Nullable
    public <Node> List<Node> findShortestPath(@NotNull InboundSemiGraph<Node> graph2, @NotNull Node start2, @NotNull Node finish) {
        return new ShortestPathFinder<Node>(graph2).findPath(start2, finish);
    }

    @NotNull
    public <Node> List<List<Node>> findKShortestPaths(@NotNull Graph<Node> graph2, @NotNull Node start2, @NotNull Node finish, int k, @NotNull ProgressIndicator progressIndicator2) {
        return new KShortestPathsFinder<Node>(graph2, start2, finish, progressIndicator2).findShortestPaths(k);
    }

    @NotNull
    public <Node> Set<List<Node>> findCycles(@NotNull Graph<Node> graph2, @NotNull Node node) {
        return new CycleFinder<Node>(graph2).getNodeCycles(node);
    }

    @NotNull
    public <Node> Graph<Node> invertEdgeDirections(final @NotNull Graph<Node> graph2) {
        return new Graph<Node>(){

            @NotNull
            public Collection<Node> getNodes() {
                return graph2.getNodes();
            }

            @NotNull
            public Iterator<Node> getIn(Node n) {
                return graph2.getOut(n);
            }

            @NotNull
            public Iterator<Node> getOut(Node n) {
                return graph2.getIn(n);
            }
        };
    }

    @NotNull
    public <Node> Graph<Chunk<Node>> computeSCCGraph(final @NotNull Graph<Node> graph2) {
        DFSTBuilder builder2 = new DFSTBuilder(graph2);
        Collection components = builder2.getComponents();
        final ArrayList<Chunk> chunks = new ArrayList<Chunk>(components.size());
        final LinkedHashMap nodeToChunkMap = new LinkedHashMap();
        for (Collection component2 : components) {
            Set chunkNodes = component2.size() == 1 ? Collections.singleton(component2.iterator().next()) : new LinkedHashSet(component2);
            Chunk chunk = new Chunk(chunkNodes);
            chunks.add(chunk);
            for (Object node : component2) {
                nodeToChunkMap.put(node, chunk);
            }
        }
        return GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<Chunk<Node>>(){

            @NotNull
            public Collection<Chunk<Node>> getNodes() {
                return chunks;
            }

            @NotNull
            public Iterator<Chunk<Node>> getIn(Chunk<Node> chunk) {
                Set chunkNodes = chunk.getNodes();
                LinkedHashSet ins = new LinkedHashSet();
                for (Object node : chunkNodes) {
                    Iterator nodeIns = graph2.getIn(node);
                    while (nodeIns.hasNext()) {
                        Object in = nodeIns.next();
                        if (chunk.containsNode(in)) continue;
                        ins.add(nodeToChunkMap.get(in));
                    }
                }
                return ins.iterator();
            }
        }));
    }

    public <Node> void collectOutsRecursively(@NotNull Graph<Node> graph2, Node start2, Set<? super Node> set) {
        if (!set.add(start2)) {
            return;
        }
        Stack stack = new Stack();
        stack.push(start2);
        while (!stack.empty()) {
            Object currentNode = stack.pop();
            Iterator successorIterator = graph2.getOut(currentNode);
            while (successorIterator.hasNext()) {
                Object successor = successorIterator.next();
                if (!set.add(successor)) continue;
                stack.push(successor);
            }
        }
    }

    @NotNull
    public <Node> Collection<Chunk<Node>> computeStronglyConnectedComponents(@NotNull Graph<Node> graph2) {
        return this.computeSCCGraph(graph2).getNodes();
    }

    @NotNull
    public <Node> List<List<Node>> removePathsWithCycles(@NotNull List<? extends List<Node>> paths) {
        ArrayList<List<Node>> result2 = new ArrayList<List<Node>>();
        for (List<Node> path : paths) {
            if (GraphAlgorithmsImpl.containsCycle(path)) continue;
            result2.add(path);
        }
        return result2;
    }

    private static boolean containsCycle(List<?> path) {
        return new HashSet(path).size() != path.size();
    }
}

