/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.gist;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.GistManager;
import com.intellij.util.gist.PsiFileGist;
import com.intellij.util.gist.PsiFileGistImpl;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.gist.VirtualFileGistImpl;
import com.intellij.util.io.DataExternalizer;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class GistManagerImpl
extends GistManager {
    private static final Logger LOG = Logger.getInstance(GistManagerImpl.class);
    private static final Set<String> ourKnownIds = ContainerUtil.newConcurrentSet();
    private static final String ourPropertyName = "file.gist.reindex.count";
    private final AtomicInteger myReindexCount = new AtomicInteger(PropertiesComponent.getInstance().getInt("file.gist.reindex.count", 0));

    @NotNull
    public <Data> VirtualFileGist<Data> newVirtualFileGist(@NotNull String id2, int version2, @NotNull DataExternalizer<Data> externalizer, @NotNull VirtualFileGist.GistCalculator<Data> calcData) {
        if (!ourKnownIds.add(id2)) {
            throw new IllegalArgumentException("Gist '" + id2 + "' is already registered");
        }
        return new VirtualFileGistImpl<Data>(id2, version2, externalizer, calcData);
    }

    @NotNull
    public <Data> PsiFileGist<Data> newPsiFileGist(@NotNull String id2, int version2, @NotNull DataExternalizer<Data> externalizer, @NotNull NullableFunction<PsiFile, Data> calculator) {
        return new PsiFileGistImpl<Data>(id2, version2, externalizer, calculator);
    }

    int getReindexCount() {
        return this.myReindexCount.get();
    }

    public void invalidateData() {
        this.invalidateGists();
        GistManagerImpl.invalidateDependentCaches();
    }

    public void invalidateData(@NotNull VirtualFile file2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invalidating gist " + file2);
        }
        this.invalidateData();
    }

    private void invalidateGists() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invalidating gists", new Throwable());
        }
        PropertiesComponent.getInstance().setValue(ourPropertyName, this.myReindexCount.incrementAndGet(), 0);
    }

    private static void invalidateDependentCaches() {
        GuiUtils.invokeLaterIfNeeded(() -> {
            for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
        }, (ModalityState)ModalityState.NON_MODAL);
    }

    public void resetReindexCount() {
        this.myReindexCount.set(0);
        PropertiesComponent.getInstance().unsetValue(ourPropertyName);
    }

    static final class MyBulkFileListener
    implements BulkFileListener {
        MyBulkFileListener() {
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            if (events.stream().anyMatch(MyBulkFileListener::shouldDropCache)) {
                ((GistManagerImpl)GistManager.getInstance()).invalidateGists();
            }
        }

        private static boolean shouldDropCache(VFileEvent e) {
            if (!(e instanceof VFilePropertyChangeEvent)) {
                return false;
            }
            String propertyName = ((VFilePropertyChangeEvent)e).getPropertyName();
            return propertyName.equals("name") || propertyName.equals("encoding");
        }
    }
}

