/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.util.Bitness;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JdkVersionDetector;

public class JdkBundle {
    private static final String BUNDLED_JDK_DIR_NAME = "jbr";
    private final File myLocation;
    private final JdkVersionDetector.JdkVersionInfo myVersionInfo;
    private final boolean myBoot;
    private final boolean myBundled;
    private final boolean myJdk;

    private JdkBundle(File location, JdkVersionDetector.JdkVersionInfo versionInfo, boolean boot, boolean bundled, boolean jdk) {
        this.myLocation = location;
        this.myVersionInfo = versionInfo;
        this.myBoot = boot;
        this.myBundled = bundled;
        this.myJdk = jdk;
    }

    @NotNull
    public File getLocation() {
        return this.myLocation;
    }

    @NotNull
    public JavaVersion getBundleVersion() {
        return this.myVersionInfo.version;
    }

    @NotNull
    public Bitness getBitness() {
        return this.myVersionInfo.bitness;
    }

    public boolean isBoot() {
        return this.myBoot;
    }

    public boolean isBundled() {
        return this.myBundled;
    }

    public boolean isJdk() {
        return this.myJdk;
    }

    @NotNull
    public File getHome() {
        return this.getVMExecutable().getParentFile().getParentFile();
    }

    @NotNull
    public File getVMExecutable() {
        File javaPath;
        File contents;
        File home = this.myLocation;
        if (SystemInfo.isMac && (contents = new File(home, "Contents/Home")).isDirectory()) {
            home = contents;
        }
        if (!(javaPath = new File(home, SystemInfo.isWindows ? "bin\\java.exe" : "bin/java")).isFile()) {
            javaPath = new File(home, SystemInfo.isWindows ? "jre\\bin\\java.exe" : "jre/bin/java");
        }
        return javaPath;
    }

    public boolean isOperational() {
        if (this.myBoot) {
            return true;
        }
        File javaPath = this.getVMExecutable();
        if (SystemInfo.isUnix && !javaPath.canExecute()) {
            return false;
        }
        try {
            ProcessOutput output = ExecUtil.execAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{javaPath.getPath(), "-version"}));
            return output.getExitCode() == 0;
        }
        catch (ExecutionException e) {
            Logger.getInstance(JdkBundle.class).debug((Throwable)e);
            return false;
        }
    }

    @NotNull
    public static JdkBundle createBoot() {
        File home = new File(SystemProperties.getJavaHome());
        JdkBundle bundle = JdkBundle.createBundle(home, true);
        assert (bundle != null) : home;
        return bundle;
    }

    @Nullable
    public static JdkBundle createBundled() {
        return JdkBundle.createBundle(new File(PathManager.getHomePath(), BUNDLED_JDK_DIR_NAME), false);
    }

    @Nullable
    public static JdkBundle createBundle(@NotNull File bundleHome) {
        return JdkBundle.createBundle(bundleHome, false);
    }

    private static JdkBundle createBundle(File bundleHome, boolean boot) {
        JdkVersionDetector.JdkVersionInfo versionInfo;
        File jdk;
        if ("jre".equals(bundleHome.getName()) && new File(jdk = bundleHome.getParentFile(), "lib").isDirectory()) {
            bundleHome = jdk;
        }
        File actualHome = bundleHome;
        if (SystemInfo.isMac) {
            if (actualHome.getName().equals("Home") && actualHome.getParentFile().getName().equals("Contents")) {
                bundleHome = actualHome.getParentFile().getParentFile();
            } else {
                File contents = new File(bundleHome, "Contents/Home");
                if (contents.isDirectory()) {
                    actualHome = contents;
                }
            }
        }
        if ((versionInfo = boot ? new JdkVersionDetector.JdkVersionInfo(JavaVersion.current(), SystemInfo.is64Bit ? Bitness.x64 : Bitness.x32) : JdkVersionDetector.getInstance().detectJdkVersionInfo(actualHome.getPath())) != null) {
            boolean bundled = PathManager.isUnderHomeDirectory((String)bundleHome.getPath());
            boolean jdk2 = JdkUtil.checkForJdk((File)actualHome);
            return new JdkBundle(bundleHome, versionInfo, boot, bundled, jdk2);
        }
        return null;
    }
}

