/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.CachedValueBase;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IdempotenceChecker {
    private static final Logger LOG = Logger.getInstance(IdempotenceChecker.class);
    private static final Set<Class<?>> ourReportedValueClasses = Collections.synchronizedSet(new THashSet());
    private static final ThreadLocal<Integer> ourRandomCheckNesting = ThreadLocal.withInitial(() -> 0);
    private static final ThreadLocal<List<String>> ourLog = new ThreadLocal();
    private static final RegistryValue ourRateCheckProperty = Registry.get((String)"platform.random.idempotence.check.rate");
    private static final Map<Class, Set<Class>> allSupersWithEquals = ConcurrentFactoryMap.createMap(clazz -> JBIterable.generate((Object)clazz, Class::getSuperclass).filter(c -> c != Object.class && ReflectionUtil.getDeclaredMethod((Class)c, (String)"equals", (Class[])new Class[]{Object.class}) != null).toSet());

    public static <T> void checkEquivalence(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue) {
        String msg = IdempotenceChecker.checkValueEquivalence(existing, fresh);
        if (msg != null) {
            IdempotenceChecker.reportFailure(existing, fresh, providerClass, recomputeValue, msg);
        }
    }

    private static <T> void reportFailure(@Nullable T existing, @Nullable T fresh, @NotNull Class<?> providerClass, @Nullable Computable<? extends T> recomputeValue, String msg) {
        boolean shouldReport;
        boolean bl = shouldReport = ApplicationManager.getApplication().isUnitTestMode() || ourReportedValueClasses.add(providerClass);
        if (shouldReport) {
            if (recomputeValue != null) {
                msg = msg + IdempotenceChecker.recomputeWithLogging(existing, fresh, recomputeValue);
            }
            LOG.error(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static <T> String recomputeWithLogging(@Nullable T existing, @Nullable T fresh, @NotNull Computable<? extends T> recomputeValue) {
        boolean outermost;
        List<String> threadLog = ourLog.get();
        boolean bl = outermost = threadLog == null;
        if (outermost) {
            threadLog = new ArrayList<String>();
            ourLog.set(threadLog);
        }
        try {
            int start2 = threadLog.size();
            Object freshest = recomputeValue.compute();
            String msg = "\n\nRecomputation gives " + IdempotenceChecker.objAndClass(freshest);
            msg = IdempotenceChecker.checkValueEquivalence(existing, freshest) == null ? msg + " which is equivalent to 'existing'" : (IdempotenceChecker.checkValueEquivalence(fresh, freshest) == null ? msg + " which is equivalent to 'fresh'" : msg + " which is different from both values");
            List<String> log = threadLog.subList(start2, threadLog.size());
            if (!log.isEmpty()) {
                msg = msg + "\nRecomputation log:\n" + StringUtil.join(log, s -> "  " + s, (String)"\n");
            }
            String string = msg;
            return string;
        }
        finally {
            if (outermost) {
                ourLog.set(null);
            }
        }
    }

    private static String objAndClass(Object o) {
        if (o == null) {
            return "null";
        }
        String s = o.toString();
        return s.contains(o.getClass().getSimpleName()) || o instanceof String || o instanceof Number || o instanceof Class ? s : s + " (class " + o.getClass().getName() + ")";
    }

    private static String checkValueEquivalence(@Nullable Object existing, @Nullable Object fresh) {
        if (existing == fresh) {
            return null;
        }
        String eqMsg = IdempotenceChecker.checkClassEquivalence(existing, fresh);
        if (eqMsg != null) {
            return eqMsg;
        }
        Object[] eArray = IdempotenceChecker.asArray(existing);
        if (eArray != null) {
            return IdempotenceChecker.checkArrayEquivalence(eArray, Objects.requireNonNull(IdempotenceChecker.asArray(fresh)), existing);
        }
        if (existing instanceof CachedValueBase.Data) {
            return IdempotenceChecker.checkCachedValueData((CachedValueBase.Data)existing, (CachedValueBase.Data)fresh);
        }
        if (existing instanceof List || IdempotenceChecker.isOrderedSet(existing)) {
            return IdempotenceChecker.checkCollectionElements((Collection)existing, (Collection)fresh);
        }
        if (IdempotenceChecker.isOrderedMap(existing)) {
            return IdempotenceChecker.checkCollectionElements(((Map)existing).entrySet(), ((Map)fresh).entrySet());
        }
        if (existing instanceof Set) {
            return IdempotenceChecker.whichIsField("size", existing, fresh, IdempotenceChecker.checkCollectionSizes(((Set)existing).size(), ((Set)fresh).size()));
        }
        if (existing instanceof Map) {
            if (existing instanceof ConcurrentMap) {
                return null;
            }
            return IdempotenceChecker.whichIsField("size", existing, fresh, IdempotenceChecker.checkCollectionSizes(((Map)existing).size(), ((Map)fresh).size()));
        }
        if (existing instanceof PsiNamedElement) {
            return IdempotenceChecker.checkPsiEquivalence((PsiElement)existing, (PsiElement)fresh);
        }
        if (existing instanceof ResolveResult) {
            PsiElement freshPsi;
            PsiElement existingPsi = ((ResolveResult)existing).getElement();
            if (existingPsi != (freshPsi = ((ResolveResult)fresh).getElement())) {
                String s = IdempotenceChecker.checkClassEquivalence(existingPsi, freshPsi);
                if (s == null) {
                    s = IdempotenceChecker.checkPsiEquivalence(existingPsi, freshPsi);
                }
                return IdempotenceChecker.whichIsField("element", existing, fresh, s);
            }
            return null;
        }
        if (IdempotenceChecker.isExpectedToHaveSaneEquals(existing) && !existing.equals(fresh)) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        return null;
    }

    private static boolean isOrderedMap(Object o) {
        return o instanceof LinkedHashMap || o instanceof SortedMap;
    }

    private static boolean isOrderedSet(Object o) {
        return o instanceof LinkedHashSet || o instanceof SortedSet;
    }

    private static String whichIsField(@NotNull String field, @NotNull Object existing, @NotNull Object fresh, @Nullable String msg) {
        return msg == null ? null : IdempotenceChecker.appendDetail(msg, "which is " + field + " of " + existing + " and " + fresh);
    }

    private static Object @Nullable [] asArray(Object o) {
        if (o instanceof Object[]) {
            return (Object[])o;
        }
        if (o instanceof Map.Entry) {
            return new Object[]{((Map.Entry)o).getKey(), ((Map.Entry)o).getValue()};
        }
        if (o instanceof Pair) {
            return new Object[]{((Pair)o).first, ((Pair)o).second};
        }
        if (o instanceof Trinity) {
            return new Object[]{((Trinity)o).first, ((Trinity)o).second, ((Trinity)o).third};
        }
        return null;
    }

    private static String checkCachedValueData(@NotNull CachedValueBase.Data existing, @NotNull CachedValueBase.Data fresh) {
        Object[] deps1 = existing.getDependencies();
        Object[] deps2 = fresh.getDependencies();
        Object eValue = existing.get();
        Object fValue = fresh.get();
        if (deps1.length != deps2.length) {
            String msg = IdempotenceChecker.reportProblem(deps1.length, deps2.length);
            msg = IdempotenceChecker.appendDetail(msg, "which is length of CachedValue dependencies: " + Arrays.toString(deps1) + " and " + Arrays.toString(deps2));
            msg = IdempotenceChecker.appendDetail(msg, "where values are  " + IdempotenceChecker.objAndClass(eValue) + " and " + IdempotenceChecker.objAndClass(fValue));
            return msg;
        }
        return IdempotenceChecker.checkValueEquivalence(eValue, fValue);
    }

    private static boolean isExpectedToHaveSaneEquals(@NotNull Object existing) {
        return existing instanceof Comparable;
    }

    @Contract(value="null,_->!null;_,null->!null")
    private static String checkClassEquivalence(@Nullable Object existing, @Nullable Object fresh) {
        Class<?> c2;
        if (existing == null || fresh == null) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        Class<?> c1 = existing.getClass();
        if (c1 != (c2 = fresh.getClass()) && !IdempotenceChecker.objectsOfDifferentClassesCanStillBeEquivalent(existing, fresh)) {
            return IdempotenceChecker.whichIsField("class", existing, fresh, IdempotenceChecker.reportProblem(c1, c2));
        }
        return null;
    }

    private static boolean objectsOfDifferentClassesCanStillBeEquivalent(@NotNull Object existing, @NotNull Object fresh) {
        if (existing instanceof Map && fresh instanceof Map && IdempotenceChecker.isOrderedMap(existing) == IdempotenceChecker.isOrderedMap(fresh)) {
            return true;
        }
        if (existing instanceof Set && fresh instanceof Set && IdempotenceChecker.isOrderedSet(existing) == IdempotenceChecker.isOrderedSet(fresh)) {
            return true;
        }
        if (existing instanceof List && fresh instanceof List) {
            return true;
        }
        return ContainerUtil.intersects((Collection)allSupersWithEquals.get(existing.getClass()), (Collection)allSupersWithEquals.get(fresh.getClass()));
    }

    private static String checkPsiEquivalence(@NotNull PsiElement existing, @NotNull PsiElement fresh) {
        if (!(existing.equals(fresh) || existing.isEquivalentTo(fresh) || fresh.isEquivalentTo(existing) || !IdempotenceChecker.seemsToBeResolveTarget(existing) && !IdempotenceChecker.seemsToBeResolveTarget(fresh))) {
            return IdempotenceChecker.reportProblem(existing, fresh);
        }
        return null;
    }

    private static boolean seemsToBeResolveTarget(@NotNull PsiElement psi) {
        if (psi.isPhysical()) {
            return true;
        }
        PsiElement nav = psi.getNavigationElement();
        return nav != null && nav.isPhysical();
    }

    private static String checkCollectionElements(@NotNull Collection existing, @NotNull Collection fresh) {
        if (fresh.isEmpty()) {
            return null;
        }
        return IdempotenceChecker.checkArrayEquivalence(existing.toArray(), fresh.toArray(), existing);
    }

    private static String checkCollectionSizes(int size1, int size2) {
        if (size2 == 0) {
            return null;
        }
        if (size1 != size2) {
            return IdempotenceChecker.reportProblem(size1, size2);
        }
        return null;
    }

    private static String checkArrayEquivalence(Object[] a1, Object[] a2, Object original1) {
        int len1 = a1.length;
        int len2 = a2.length;
        if (len1 != len2) {
            return IdempotenceChecker.appendDetail(IdempotenceChecker.reportProblem(len1, len2), "which is length of " + Arrays.toString(a1) + " and " + Arrays.toString(a2));
        }
        for (int i2 = 0; i2 < len1; ++i2) {
            String msg = IdempotenceChecker.checkValueEquivalence(a1[i2], a2[i2]);
            if (msg == null) continue;
            return IdempotenceChecker.whichIsField(original1 instanceof Map.Entry ? (i2 == 0 ? "key" : "value") : i2 + "th element", Arrays.toString(a1), Arrays.toString(a2), msg);
        }
        return null;
    }

    private static String reportProblem(Object o1, Object o2) {
        return IdempotenceChecker.appendDetail("Non-idempotent computation: it returns different results when invoked multiple times or on different threads:", IdempotenceChecker.objAndClass(o1) + " != " + IdempotenceChecker.objAndClass(o2));
    }

    private static String appendDetail(String message, String detail) {
        return message + "\n  " + StringUtil.trimLog((String)detail, (int)10000);
    }

    public static boolean areRandomChecksEnabled() {
        return ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest();
    }

    public static void disableRandomChecksUntil(Disposable parentDisposable) {
        ourRateCheckProperty.setValue(0, parentDisposable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void applyForRandomCheck(T data2, Object provider, Computable<? extends T> recomputeValue) {
        if (IdempotenceChecker.areRandomChecksEnabled() && IdempotenceChecker.shouldPerformRandomCheck()) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            Integer prevNesting = ourRandomCheckNesting.get();
            ourRandomCheckNesting.set(prevNesting + 1);
            try {
                Object fresh = recomputeValue.compute();
                if (stamp.mayCacheNow()) {
                    IdempotenceChecker.checkEquivalence(data2, fresh, provider.getClass(), recomputeValue);
                }
            }
            finally {
                ourRandomCheckNesting.set(prevNesting);
            }
        }
    }

    private static boolean shouldPerformRandomCheck() {
        int rate = ourRateCheckProperty.asInteger();
        return rate > 0 && ThreadLocalRandom.current().nextInt(rate) == 0;
    }

    public static boolean isCurrentThreadInsideRandomCheck() {
        return ourRandomCheckNesting.get() > 0;
    }

    public static boolean isLoggingEnabled() {
        return ourLog.get() != null;
    }

    public static void logTrace(@NotNull String message) {
        List<String> log = ourLog.get();
        if (log != null) {
            log.add(message);
        }
    }
}

