/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabDescriptor;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.TabbedContentImpl;
import com.intellij.util.ContentsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ContentUtilEx
extends ContentsUtil {
    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull @NonNls String groupPrefix, @NotNull @Nls String tabName, boolean select, @Nullable Disposable childDisposable) {
        ContentUtilEx.addTabbedContent(manager, new TabGroupId(groupPrefix, groupPrefix), new TabDescriptor(contentComponent, () -> tabName, childDisposable), select);
    }

    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, @NotNull @NonNls String groupId2, @NotNull Supplier<@Nls String> groupDisplayName, @NotNull Supplier<@Nls String> tabDisplayName, boolean select, @Nullable Disposable childDisposable) {
        ContentUtilEx.addTabbedContent(manager, new TabGroupId(groupId2, groupDisplayName), new TabDescriptor(contentComponent, tabDisplayName, childDisposable), select);
    }

    public static void addTabbedContent(@NotNull ContentManager manager, @NotNull TabGroupId tabGroupId, @NotNull TabDescriptor tab, boolean select) {
        if (ContentUtilEx.isSplitMode(tabGroupId.getId())) {
            ContentUtilEx.addSplitTabbedContent(manager, tabGroupId, tab, select);
        } else {
            ContentUtilEx.addMergedTabbedContent(manager, tabGroupId, tab, select);
        }
    }

    public static void addSplitTabbedContent(@NotNull ContentManager manager, @NotNull TabGroupId tabGroupId, @NotNull TabDescriptor tab, boolean select) {
        Content content2 = ContentFactory.SERVICE.getInstance().createContent(tab.getComponent(), tabGroupId.getDisplayName(tab), true);
        content2.setTabName(tabGroupId.getDisplayName(tab));
        content2.putUserData(Content.TABBED_CONTENT_KEY, (Object)Boolean.TRUE);
        content2.putUserData(Content.TAB_GROUP_ID_KEY, (Object)tabGroupId);
        content2.putUserData(Content.TAB_GROUP_NAME_KEY, (Object)tabGroupId.getId());
        content2.putUserData(Content.TAB_DESCRIPTOR_KEY, (Object)tab);
        Disposer.register((Disposable)content2, (Disposable)tab);
        ContentUtilEx.addContent((ContentManager)manager, (Content)content2, (boolean)select);
    }

    private static void addMergedTabbedContent(@NotNull ContentManager manager, @NotNull TabGroupId tabGroupId, @NotNull TabDescriptor tab, boolean select) {
        TabbedContent tabbedContent = ContentUtilEx.findTabbedContent(manager, tabGroupId.getId());
        if (tabbedContent != null) {
            if (select) {
                manager.setSelectedContent((Content)tabbedContent, true, true);
            }
            tabbedContent.addContent(tab, true);
            return;
        }
        ContentUtilEx.createMergedTabbedContent(manager, tabGroupId, Collections.singletonList(tab), tab, select);
    }

    private static void createMergedTabbedContent(@NotNull ContentManager manager, @NotNull TabGroupId tabGroupId, @NotNull List<TabDescriptor> tabs, @Nullable TabDescriptor tabToSelect, boolean selectContent) {
        Iterator<TabDescriptor> iterator2 = tabs.iterator();
        TabbedContentImpl tabbedContent = new TabbedContentImpl(tabGroupId, iterator2.next(), true);
        ContentUtilEx.addContent((ContentManager)manager, (Content)tabbedContent, (boolean)selectContent);
        while (iterator2.hasNext()) {
            TabDescriptor tab;
            tabbedContent.addContent(tab, (tab = iterator2.next()) == tabToSelect);
        }
    }

    @Nullable
    public static TabbedContent findTabbedContent(@NotNull ContentManager manager, @NotNull @NonNls String id2) {
        for (Content content2 : manager.getContents()) {
            if (!(content2 instanceof TabbedContent) || !((TabbedContent)content2).getId().getId().equals(id2)) continue;
            return (TabbedContent)content2;
        }
        return null;
    }

    @NotNull
    public static String getFullName(@NotNull String groupPrefix, @NotNull String tabName) {
        if (tabName.isEmpty()) {
            return groupPrefix;
        }
        return groupPrefix + ": " + tabName;
    }

    public static boolean selectContent(@NotNull ContentManager manager, @NotNull JComponent contentComponent, boolean requestFocus) {
        for (Content content2 : manager.getContents()) {
            if (content2 instanceof TabbedContentImpl) {
                boolean found = ((TabbedContentImpl)content2).findAndSelectContent(contentComponent);
                if (!found) continue;
                manager.setSelectedContent(content2, requestFocus);
                return true;
            }
            if (!Comparing.equal((Object)content2.getComponent(), (Object)contentComponent)) continue;
            manager.setSelectedContent(content2, requestFocus);
            return true;
        }
        return false;
    }

    @Nullable
    public static JComponent findContentComponent(@NotNull ContentManager manager, @NotNull Condition<? super JComponent> condition) {
        for (Content content2 : manager.getContents()) {
            if (content2 instanceof TabbedContent) {
                JComponent component2 = ContentUtilEx.findContentComponent((TabbedContent)content2, condition);
                if (component2 == null) continue;
                return component2;
            }
            if (!condition.value((Object)content2.getComponent())) continue;
            return content2.getComponent();
        }
        return null;
    }

    @Nullable
    private static JComponent findContentComponent(@NotNull TabbedContent tabbedContent, @NotNull Condition<? super JComponent> condition) {
        for (Pair tab : tabbedContent.getTabs()) {
            if (!condition.value(tab.second)) continue;
            return (JComponent)tab.second;
        }
        return null;
    }

    public static boolean closeContentTab(@NotNull ContentManager manager, @NotNull Condition<? super JComponent> condition) {
        for (Content content2 : manager.getContents()) {
            if (content2 instanceof TabbedContent && ((TabbedContent)content2).hasMultipleTabs()) {
                TabbedContent tabbedContent = (TabbedContent)content2;
                JComponent component2 = ContentUtilEx.findContentComponent(tabbedContent, condition);
                if (component2 == null) continue;
                tabbedContent.removeContent(component2);
                return true;
            }
            if (!condition.value((Object)content2.getComponent())) continue;
            manager.removeContent(content2, true);
            return true;
        }
        return false;
    }

    public static int getSelectedTab(@NotNull TabbedContent content2) {
        int selectedIndex = content2.getSelectedIndex();
        if (selectedIndex != -1) {
            return selectedIndex;
        }
        JComponent current2 = content2.getComponent();
        int index = 0;
        for (Pair tab : content2.getTabs()) {
            if (tab.second == current2) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static void updateTabbedContentDisplayName(@NotNull ContentManager manager, @NotNull JComponent contentComponent) {
        for (Content content2 : manager.getContents()) {
            if (!Comparing.equal((Object)content2.getComponent(), (Object)contentComponent)) continue;
            TabGroupId groupId2 = (TabGroupId)content2.getUserData(Content.TAB_GROUP_ID_KEY);
            TabDescriptor tab = (TabDescriptor)content2.getUserData(Content.TAB_DESCRIPTOR_KEY);
            if (groupId2 == null || tab == null) continue;
            content2.setDisplayName(groupId2.getDisplayName(tab));
            return;
        }
    }

    public static void mergeTabs(@NotNull ContentManager manager, @NotNull TabGroupId groupId2) {
        ArrayList<TabDescriptor> tabs = new ArrayList<TabDescriptor>();
        Content selectedContent = manager.getSelectedContent();
        TabDescriptor selectedTab = null;
        ArrayList<Content> mergedContent = new ArrayList<Content>();
        for (Content content2 : manager.getContents()) {
            if (!groupId2.equals(content2.getUserData(Content.TAB_GROUP_ID_KEY))) continue;
            TabDescriptor tab = (TabDescriptor)content2.getUserData(Content.TAB_DESCRIPTOR_KEY);
            if (tab == null) {
                tab = new TabDescriptor(content2.getComponent(), content2.getDisplayName().substring(groupId2.getDisplayName().length() + 2));
            }
            if (content2 == selectedContent) {
                selectedTab = tab;
            }
            tabs.add(tab);
            manager.removeContent(content2, false);
            content2.setComponent(null);
            content2.setShouldDisposeContent(false);
            mergedContent.add(content2);
        }
        ContentUtilEx.setSplitMode(groupId2.getId(), false);
        ContentUtilEx.createMergedTabbedContent(manager, groupId2, tabs, selectedTab, selectedTab != null);
        mergedContent.forEach(Disposer::dispose);
    }

    public static boolean isSplitMode(@NonNls @NotNull String groupId2) {
        return PropertiesComponent.getInstance().getBoolean("tabbed.toolwindow.expanded." + groupId2, false);
    }

    public static void setSplitMode(@NonNls @NotNull String groupId2, boolean value2) {
        if (value2) {
            PropertiesComponent.getInstance().setValue("tabbed.toolwindow.expanded." + groupId2, Boolean.TRUE.toString());
        } else {
            PropertiesComponent.getInstance().unsetValue("tabbed.toolwindow.expanded." + groupId2);
        }
    }
}

