/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PathChooserDialogHelper;
import com.intellij.ui.UIBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.OwnerOptional;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WinPathChooserDialog
implements PathChooserDialog,
FileChooserDialog {
    private FileDialog myFileDialog;
    private final FileChooserDescriptor myFileChooserDescriptor;
    private final WeakReference<Component> myParent;
    private final Project myProject;
    private final String myTitle;
    private VirtualFile[] virtualFiles;
    private final PathChooserDialogHelper myHelper;

    public WinPathChooserDialog(FileChooserDescriptor descriptor2, Component parent, Project project) {
        this.myHelper = new PathChooserDialogHelper(descriptor2);
        this.myFileChooserDescriptor = descriptor2;
        this.myParent = new WeakReference<Component>(parent);
        this.myProject = project;
        this.myTitle = WinPathChooserDialog.getChooserTitle(descriptor2);
        Consumer dialogConsumer = owner -> {
            this.myFileDialog = new FileDialog((Dialog)owner, this.myTitle, 0);
        };
        Consumer frameConsumer = owner -> {
            this.myFileDialog = new FileDialog((Frame)owner, this.myTitle, 0);
        };
        OwnerOptional.fromComponent(parent).ifDialog((Consumer<? super Dialog>)dialogConsumer).ifFrame((Consumer<? super Frame>)frameConsumer).ifNull((Consumer<? super Frame>)frameConsumer);
    }

    private static String getChooserTitle(FileChooserDescriptor descriptor2) {
        String title = descriptor2.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void choose(@Nullable VirtualFile toSelect2, @NotNull Consumer<? super List<VirtualFile>> callback2) {
        boolean appStarted;
        if (toSelect2 != null && toSelect2.getParent() != null) {
            String directoryName;
            String fileName = null;
            if (toSelect2.isDirectory()) {
                directoryName = toSelect2.getCanonicalPath();
            } else {
                directoryName = toSelect2.getParent().getCanonicalPath();
                fileName = toSelect2.getPath();
            }
            this.myFileDialog.setDirectory(directoryName);
            this.myFileDialog.setFile(fileName);
        }
        this.myFileDialog.setFilenameFilter((dir, name) -> {
            File file2 = new File(dir, name);
            return this.myFileChooserDescriptor.isFileSelectable(this.myHelper.fileToVirtualFile(file2));
        });
        this.myFileDialog.setMultipleMode(this.myFileChooserDescriptor.isChooseMultiple());
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean bl = appStarted = commandProcessor != null;
        if (appStarted) {
            commandProcessor.enterModal();
            LaterInvocator.enterModal(this.myFileDialog);
        }
        Component parent = (Component)this.myParent.get();
        try {
            this.myFileDialog.setVisible(true);
        }
        finally {
            if (appStarted) {
                commandProcessor.leaveModal();
                LaterInvocator.leaveModal(this.myFileDialog);
                if (parent != null) {
                    parent.requestFocus();
                }
            }
        }
        Object[] files2 = this.myFileDialog.getFiles();
        List<VirtualFile> virtualFileList = this.myHelper.getChosenFiles((File[])files2);
        this.virtualFiles = virtualFileList.toArray(VirtualFile.EMPTY_ARRAY);
        if (!virtualFileList.isEmpty()) {
            try {
                if (virtualFileList.size() == 1) {
                    this.myFileChooserDescriptor.isFileSelectable(virtualFileList.get(0));
                }
                this.myFileChooserDescriptor.validateSelectedFiles(this.virtualFiles);
            }
            catch (Exception e) {
                if (parent == null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.myTitle);
                } else {
                    Messages.showErrorDialog((Component)parent, (String)e.getMessage(), (String)this.myTitle);
                }
                return;
            }
            if (!ArrayUtil.isEmpty((Object[])files2)) {
                callback2.consume(virtualFileList);
            } else if (callback2 instanceof FileChooser.FileChooserConsumer) {
                ((FileChooser.FileChooserConsumer)callback2).cancelled();
            }
        }
    }

    @NotNull
    private static FileDialog createFileDialogWithoutOwner(String title, int load2) {
        return new FileDialog((Frame)null, title, load2);
    }

    public VirtualFile @NotNull [] choose(@Nullable VirtualFile toSelect2, @Nullable Project project) {
        this.choose(toSelect2, (Consumer<? super List<VirtualFile>>)((Consumer)files2 -> {}));
        return this.virtualFiles;
    }

    public VirtualFile @NotNull [] choose(@Nullable Project project, VirtualFile ... toSelect2) {
        return this.choose(toSelect2.length > 0 ? toSelect2[0] : null, project);
    }
}

