/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;

final class ModelAccessor {
    private static final Logger LOG = Logger.getInstance(ModelAccessor.class);
    private final TreeModel model;
    private final Invoker invoker;

    ModelAccessor(@NotNull TreeModel model) {
        this.model = model;
        if (model instanceof InvokerSupplier) {
            InvokerSupplier supplier2 = (InvokerSupplier)((Object)model);
            this.invoker = supplier2.getInvoker();
        } else {
            this.invoker = null;
        }
    }

    public boolean isActualModel(@Nullable TreeModel model) {
        return this.model == model;
    }

    @NotNull
    public CancellablePromise<NodeContent> promiseRootContent() {
        return this.compute(obsolescent -> this.getRootContent((Obsolescent)obsolescent));
    }

    @NotNull
    public CancellablePromise<NodeStructure> promiseNodeStructure(@NotNull Object node) {
        return this.compute(obsolescent -> this.getNodeStructure((Obsolescent)obsolescent, node));
    }

    @NotNull
    private <T> CancellablePromise<T> compute(@NotNull Function<Obsolescent, T> function) {
        AsyncPromise promise = new AsyncPromise();
        if (this.invoker != null) {
            this.invoker.compute(() -> function.apply(() -> ((AsyncPromise)promise).isDone())).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0)).onSuccess(result2 -> EventQueue.invokeLater(() -> {
                if (!promise.isDone()) {
                    promise.setResult(result2);
                }
            }));
        } else if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(() -> ModelAccessor.computeOnEDT(function, promise));
        } else {
            ModelAccessor.computeOnEDT(function, promise);
        }
        return promise;
    }

    private static <T> void computeOnEDT(@NotNull Function<Obsolescent, T> function, @NotNull AsyncPromise<T> promise) {
        T result2;
        assert (EventQueue.isDispatchThread());
        try {
            result2 = function.apply(() -> promise.isDone());
        }
        catch (ProcessCanceledException | IndexNotReadyException exception) {
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> ModelAccessor.computeOnEDT(function, promise), 10L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (Throwable error) {
            promise.setError(error);
            return;
        }
        promise.setResult(result2);
    }

    @Nullable
    private NodeContent getRootContent(@NotNull Obsolescent obsolescent) {
        assert (this.invoker == null ? EventQueue.isDispatchThread() : this.invoker.isValidThread());
        if (obsolescent.isObsolete()) {
            return null;
        }
        Object root = this.model.getRoot();
        if (root == null || obsolescent.isObsolete()) {
            return null;
        }
        return new NodeContent(root, LeafState.get((Object)root, (TreeModel)this.model));
    }

    @Nullable
    private NodeStructure getNodeStructure(@NotNull Obsolescent obsolescent, @NotNull Object node) {
        assert (this.invoker == null ? EventQueue.isDispatchThread() : this.invoker.isValidThread());
        if (obsolescent.isObsolete()) {
            return null;
        }
        LeafState state = LeafState.get((Object)node, (TreeModel)this.model);
        if (obsolescent.isObsolete()) {
            return null;
        }
        List<Object> list2 = Collections.emptyList();
        if (state != LeafState.ALWAYS) {
            if (this.model instanceof ChildrenProvider) {
                ChildrenProvider provider = (ChildrenProvider)((Object)this.model);
                List children2 = provider.getChildren(node);
                if (children2 == null) {
                    throw new ProcessCanceledException();
                }
                list2 = this.getChildren(obsolescent, children2.size(), children2::get);
            } else {
                list2 = this.getChildren(obsolescent, this.model.getChildCount(node), index -> this.model.getChild(node, index));
            }
        }
        if (state == LeafState.ASYNC) {
            state = list2.isEmpty() ? LeafState.ALWAYS : LeafState.NEVER;
        }
        return new NodeStructure(new NodeContent(node, state), list2);
    }

    @NotNull
    private List<NodeContent> getChildren(@NotNull Obsolescent obsolescent, int count, @NotNull IntFunction<?> function) {
        if (count < 0) {
            LOG.warn("illegal child count: " + count);
        }
        if (count <= 0) {
            return Collections.emptyList();
        }
        ArrayList<NodeContent> list2 = new ArrayList<NodeContent>(count);
        for (int index = 0; index < count; ++index) {
            ProgressManager.checkCanceled();
            if (obsolescent.isObsolete()) {
                return Collections.emptyList();
            }
            Object node = function.apply(index);
            if (node == null) {
                LOG.warn("ignore null child at " + index);
                continue;
            }
            if (list2.stream().anyMatch(content2 -> content2.hasUserNode(node))) {
                LOG.warn("ignore duplicated child at " + index + ": " + node);
                continue;
            }
            if (obsolescent.isObsolete()) {
                return Collections.emptyList();
            }
            list2.add(new NodeContent(node, LeafState.get(node, (TreeModel)this.model)));
        }
        return list2;
    }

    public String toString() {
        return this.model.toString();
    }

    static final class NodeStructure {
        private final NodeContent content;
        private final List<NodeContent> children;

        private NodeStructure(@NotNull NodeContent content2, @NotNull List<NodeContent> children2) {
            this.content = content2;
            this.children = children2;
        }

        @NotNull
        public NodeContent getContent() {
            return this.content;
        }

        @NotNull
        public List<NodeContent> getChildren() {
            return this.children;
        }
    }

    static final class NodeContent {
        private final int hashCode;
        private final Object userNode;
        private final LeafState leafState;

        private NodeContent(@NotNull Object node, @NotNull LeafState state) {
            assert (state != LeafState.DEFAULT) : "resolved state required";
            this.hashCode = node.hashCode();
            this.userNode = node;
            this.leafState = state;
        }

        @NotNull
        public Object getUserNode() {
            return this.userNode;
        }

        @NotNull
        public LeafState getLeafState() {
            return this.leafState;
        }

        boolean hasUserNodeFrom(@NotNull NodeContent content2) {
            return this.hasUserNode(content2.userNode, content2.hashCode);
        }

        boolean hasUserNode(@NotNull Object node) {
            return this.hasUserNode(node, node.hashCode());
        }

        boolean hasUserNode(@NotNull Object node, int hash) {
            return this.hashCode == hash && (this.userNode == node || this.userNode.equals(node));
        }

        public boolean equals(Object object) {
            return object == this || object instanceof NodeContent && this.hasUserNodeFrom((NodeContent)object);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

