/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.ui.OptionsSearchTopHitProvider;
import com.intellij.ide.ui.PublicMethodBasedOptionDescription;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.lang.LangBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.FileColorManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public final class FileColorsOptionsTopHitProvider
implements OptionsSearchTopHitProvider.ProjectLevelProvider {
    @Override
    @NotNull
    public String getId() {
        return "appearance";
    }

    @Override
    @NotNull
    public Collection<OptionDescription> getOptions(@NotNull Project project) {
        FileColorManager manager = FileColorManager.getInstance((Project)project);
        if (manager != null) {
            Option enabled = new Option(manager, LangBundle.message((String)"label.file.colors.enabled", (Object[])new Object[0]), "isEnabled", "setEnabled");
            return !enabled.isOptionEnabled() ? Collections.singletonList(enabled) : Collections.unmodifiableCollection(Arrays.asList(new BooleanOptionDescription[]{enabled, new Option(manager, LangBundle.message((String)"label.use.file.colors.in.editor.tabs", (Object[])new Object[0]), "isEnabledForTabs", "setEnabledForTabs"), new Option(manager, LangBundle.message((String)"label.use.file.colors.in.project.view", (Object[])new Object[0]), "isEnabledForProjectView", "setEnabledForProjectView")}));
        }
        return Collections.emptyList();
    }

    private static class Option
    extends PublicMethodBasedOptionDescription {
        private final FileColorManager myManager;

        Option(FileColorManager manager, @NlsContexts.Label String option2, String getter, String setter) {
            super(option2, "reference.settings.ide.settings.file-colors", getter, setter);
            this.myManager = manager;
        }

        public Object getInstance() {
            return this.myManager;
        }

        protected void fireUpdated() {
            UISettings.getInstance().fireUISettingsChanged();
        }
    }
}

