/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.notification.impl.ui.StickyButton;
import com.intellij.notification.impl.ui.StickyButtonUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ColorButtonBase
extends StickyButton {
    @Nullable
    protected Color myColor;

    protected ColorButtonBase(@NotNull String text, @NotNull Color color) {
        super(FileColorManagerImpl.getAlias(text));
        this.myColor = color;
        this.setUI(this.createUI());
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorButtonBase.this.doPerformAction(e);
            }
        });
        this.setOpaque(false);
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
    }

    @Override
    public void setUI(ButtonUI ui) {
        if (this.myColor == null) {
            return;
        }
        super.setUI(ui);
    }

    protected abstract void doPerformAction(ActionEvent var1);

    @NotNull
    Color getColor() {
        assert (this.myColor != null);
        return this.myColor;
    }

    public void setColor(@NotNull Color color) {
        this.myColor = color;
    }

    @Override
    public Color getForeground() {
        if (this.getModel().isSelected()) {
            return JBColor.foreground();
        }
        if (this.getModel().isRollover()) {
            return JBColor.GRAY;
        }
        return this.getColor();
    }

    @Override
    protected ButtonUI createUI() {
        return new ColorButtonUI();
    }

    protected static class ColorButtonUI
    extends StickyButtonUI<ColorButtonBase> {
        protected ColorButtonUI() {
        }

        @Override
        protected Color getBackgroundColor(@NotNull ColorButtonBase button2) {
            return button2.getColor();
        }

        @Override
        protected Color getFocusColor(@NotNull ColorButtonBase button2) {
            return StartupUiUtil.isUnderDarcula() ? button2.getColor().brighter() : button2.getColor().darker();
        }

        @Override
        protected Color getSelectionColor(@NotNull ColorButtonBase button2) {
            return button2.getColor();
        }

        @Override
        protected Color getRolloverColor(@NotNull ColorButtonBase button2) {
            return button2.getColor();
        }

        @Override
        protected int getArcSize() {
            return JBUIScale.scale((int)15);
        }
    }
}

