/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.render;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ComponentWithExpandableItems;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Collection;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class RenderingHelper {
    public static final Key<Boolean> SHRINK_LONG_RENDERER = Key.create((String)"SHRINK_LONG_RENDERER");
    private final Rectangle myViewBounds;
    private final int myHintIndex;
    private int myRightMargin;
    private boolean myShrinkingDisabled;

    @ApiStatus.Internal
    public RenderingHelper(@NotNull JComponent component2) {
        this.myViewBounds = new Rectangle(component2.getWidth(), component2.getHeight());
        this.myHintIndex = RenderingHelper.getExpandableHintIndex(component2);
        Container parent = component2.getParent();
        if (parent instanceof JViewport) {
            this.myViewBounds.setBounds(-component2.getX(), -component2.getY(), parent.getWidth(), parent.getHeight());
            parent = parent.getParent();
            if (parent instanceof JScrollPane) {
                JScrollBar vsb;
                JScrollPane pane2 = (JScrollPane)parent;
                JScrollBar hsb = pane2.getHorizontalScrollBar();
                if (hsb != null && hsb.isVisible()) {
                    this.myShrinkingDisabled = RenderingHelper.isClientPropertyFalse(component2, SHRINK_LONG_RENDERER, false);
                }
                if ((vsb = pane2.getVerticalScrollBar()) != null && vsb.isVisible() && !vsb.isOpaque() && RenderingHelper.isClientPropertyFalse(vsb, JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS, SystemInfo.isMac)) {
                    this.myRightMargin = vsb.getWidth();
                }
            }
        }
    }

    public int getX() {
        return this.myViewBounds.x;
    }

    public int getY() {
        return this.myViewBounds.y;
    }

    public int getWidth() {
        return this.myViewBounds.width;
    }

    public int getHeight() {
        return this.myViewBounds.height;
    }

    public int getRightMargin() {
        return this.myRightMargin;
    }

    public boolean isRendererShrinkingDisabled(int index) {
        return this.myShrinkingDisabled || this.isExpandableHintShown(index);
    }

    public boolean isExpandableHintShown(int index) {
        return this.myHintIndex == index;
    }

    private static int getExpandableHintIndex(@NotNull JComponent component2) {
        if (component2 instanceof ComponentWithExpandableItems) {
            Object item;
            ComponentWithExpandableItems c = (ComponentWithExpandableItems)component2;
            Collection items = c.getExpandableItemsHandler().getExpandedItems();
            Object v0 = item = items.isEmpty() ? null : items.iterator().next();
            if (item instanceof Integer) {
                return item;
            }
        }
        return -1;
    }

    private static boolean isClientPropertyFalse(@NotNull JComponent component2, @NotNull Object key, boolean strict) {
        Object property = component2.getClientProperty(key);
        return strict ? Boolean.FALSE.equals(property) : !Boolean.TRUE.equals(property);
    }
}

