/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.UIBundle;
import com.intellij.ui.popup.util.DetailView;
import com.intellij.ui.popup.util.ItemWrapper;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailViewImpl
extends JPanel
implements DetailView,
UserDataHolder {
    private final Project myProject;
    private final UserDataHolderBase myDataHolderBase = new UserDataHolderBase();
    private final JLabel myLabel = new JLabel("", 0);
    private Editor myEditor;
    private ItemWrapper myWrapper;
    private JPanel myDetailPanel;
    private JPanel myDetailPanelWrapper;
    private RangeHighlighter myHighlighter;
    private DetailView.PreviewEditorState myEditorState = DetailView.PreviewEditorState.EMPTY;
    private String myEmptyLabel = UIBundle.message((String)"message.nothingToShow", (Object[])new Object[0]);

    public DetailViewImpl(Project project) {
        super(new BorderLayout());
        this.myProject = project;
        this.setPreferredSize((Dimension)JBUI.size((int)600, (int)300));
        this.myLabel.setVerticalAlignment(0);
    }

    public void clearEditor() {
        if (this.getEditor() != null) {
            this.clearHighlighting();
            this.remove(this.getEditor().getComponent());
            EditorFactory.getInstance().releaseEditor(this.getEditor());
            this.myEditorState = DetailView.PreviewEditorState.EMPTY;
            this.setEditor(null);
            this.repaint();
        }
    }

    public void setCurrentItem(@Nullable ItemWrapper wrapper2) {
        this.myWrapper = wrapper2;
    }

    public DetailView.PreviewEditorState getEditorState() {
        return this.myEditorState;
    }

    public ItemWrapper getCurrentItem() {
        return this.myWrapper;
    }

    public boolean hasEditorOnly() {
        return false;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (ScreenUtil.isStandardAddRemoveNotify((Component)this)) {
            this.clearEditor();
        }
    }

    public Editor getEditor() {
        return this.myEditor;
    }

    public void setEditor(Editor editor) {
        this.myEditor = editor;
    }

    public void navigateInPreviewEditor(DetailView.PreviewEditorState editorState) {
        VirtualFile file2 = editorState.getFile();
        LogicalPosition positionToNavigate = editorState.getNavigate();
        TextAttributes lineAttributes = editorState.getAttributes();
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        this.clearEditor();
        this.myEditorState = editorState;
        this.remove(this.myLabel);
        if (document != null) {
            if (this.getEditor() == null || this.getEditor().getDocument() != document) {
                this.setEditor(this.createEditor(this.myProject, document, file2));
                this.add((Component)this.getEditor().getComponent(), "Center");
            }
            if (positionToNavigate != null) {
                this.getEditor().getCaretModel().moveToLogicalPosition(positionToNavigate);
                this.validate();
                this.getEditor().getScrollingModel().scrollToCaret(ScrollType.CENTER);
            } else {
                this.revalidate();
                this.repaint();
            }
            this.clearHighlighting();
            if (lineAttributes != null && positionToNavigate != null && positionToNavigate.line < this.getEditor().getDocument().getLineCount()) {
                this.myHighlighter = this.getEditor().getMarkupModel().addLineHighlighter(positionToNavigate.line, 5999, lineAttributes);
            }
        } else {
            this.myLabel.setText("Navigate to selected " + (file2.isDirectory() ? "directory " : "file ") + "in Project View");
            this.add((Component)this.myLabel, "Center");
            this.validate();
        }
    }

    @NotNull
    protected Editor createEditor(@Nullable Project project, Document document, VirtualFile file2) {
        EditorEx editor = (EditorEx)EditorFactory.getInstance().createViewer(document, project, EditorKind.PREVIEW);
        EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
        EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file2, scheme, project);
        editor.setFile(file2);
        editor.setHighlighter(highlighter);
        EditorSettings settings = editor.getSettings();
        settings.setAnimatedScrolling(false);
        settings.setRefrainFromScrolling(false);
        settings.setLineNumbersShown(true);
        settings.setFoldingOutlineShown(false);
        editor.getFoldingModel().setFoldingEnabled(false);
        return editor;
    }

    private void clearHighlighting() {
        if (this.myHighlighter != null) {
            this.getEditor().getMarkupModel().removeHighlighter(this.myHighlighter);
            this.myHighlighter = null;
        }
    }

    public JPanel getPropertiesPanel() {
        return this.myDetailPanel;
    }

    public void setPropertiesPanel(@Nullable JPanel panel2) {
        if (panel2 == null) {
            if (this.myDetailPanelWrapper != null) {
                this.myDetailPanelWrapper.removeAll();
            }
            this.myLabel.setText(this.myEmptyLabel);
            this.add((Component)this.myLabel, "Center");
        } else if (panel2 != this.myDetailPanel) {
            this.remove(this.myLabel);
            if (this.myDetailPanelWrapper == null) {
                this.myDetailPanelWrapper = new JPanel(new GridLayout(1, 1));
                this.myDetailPanelWrapper.setBorder(JBUI.Borders.empty((int)5));
                this.myDetailPanelWrapper.add(panel2);
                this.add((Component)this.myDetailPanelWrapper, "North");
            } else {
                this.myDetailPanelWrapper.removeAll();
                this.myDetailPanelWrapper.add(panel2);
            }
        }
        this.myDetailPanel = panel2;
        this.revalidate();
        this.repaint();
    }

    public void setEmptyLabel(String text) {
        this.myEmptyLabel = text;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myDataHolderBase.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
        this.myDataHolderBase.putUserData(key, value2);
    }
}

