/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.MaskProvider;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Processor;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPopupBuilderImpl
implements ComponentPopupBuilder {
    private String myTitle = "";
    private boolean myResizable;
    private boolean myMovable;
    private final JComponent myComponent;
    private final JComponent myPreferredFocusedComponent;
    private boolean myRequestFocus;
    private String myDimensionServiceKey;
    private Computable<Boolean> myCallback;
    private Project myProject;
    private boolean myCancelOnClickOutside = true;
    private boolean myCancelOnWindowDeactivation = true;
    private final Set<JBPopupListener> myListeners = new LinkedHashSet<JBPopupListener>();
    private boolean myUseDimServiceForXYLocation;
    private IconButton myCancelButton;
    private MouseChecker myCancelOnMouseOutCallback;
    private boolean myCancelOnWindow;
    private ActiveIcon myTitleIcon = new ActiveIcon(EmptyIcon.ICON_0);
    private boolean myCancelKeyEnabled = true;
    private boolean myLocateByContent;
    private boolean myPlaceWithinScreen = true;
    private Processor<? super JBPopup> myPinCallback;
    private Dimension myMinSize;
    private MaskProvider myMaskProvider;
    private float myAlpha;
    private List<Object> myUserData;
    private boolean myInStack = true;
    private boolean myModalContext = true;
    private Component[] myFocusOwners = new Component[0];
    private String myAd;
    private boolean myShowShadow = true;
    private boolean myShowBorder = true;
    private boolean myFocusable = true;
    private ActiveComponent myCommandButton;
    private List<? extends Pair<ActionListener, KeyStroke>> myKeyboardActions = Collections.emptyList();
    private Component mySettingsButtons;
    private boolean myMayBeParent;
    private int myAdAlignment = 2;
    private BooleanFunction<? super KeyEvent> myKeyEventHandler;
    private Color myBorderColor;
    private boolean myNormalWindowLevel;
    @Nullable
    private Runnable myOkHandler;

    public ComponentPopupBuilderImpl(@NotNull JComponent component2, JComponent preferredFocusedComponent) {
        this.myComponent = component2;
        this.myPreferredFocusedComponent = preferredFocusedComponent;
    }

    @NotNull
    public ComponentPopupBuilder setMayBeParent(boolean mayBeParent) {
        this.myMayBeParent = mayBeParent;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setTitle(@NlsContexts.PopupTitle String title) {
        this.myTitle = title;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setResizable(boolean resizable) {
        this.myResizable = resizable;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setMovable(boolean movable) {
        this.myMovable = movable;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnClickOutside(boolean cancel) {
        this.myCancelOnClickOutside = cancel;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnMouseOutCallback(@NotNull MouseChecker shouldCancel) {
        this.myCancelOnMouseOutCallback = shouldCancel;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder addListener(@NotNull JBPopupListener listener2) {
        this.myListeners.add(listener2);
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setFocusable(boolean focusable) {
        this.myFocusable = focusable;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setDimensionServiceKey(Project project, String key, boolean useForXYLocation) {
        this.myDimensionServiceKey = key;
        this.myUseDimServiceForXYLocation = useForXYLocation;
        this.myProject = project;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setCancelCallback(@NotNull Computable<Boolean> shouldProceed) {
        this.myCallback = shouldProceed;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setCancelButton(@NotNull IconButton cancelButton) {
        this.myCancelButton = cancelButton;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setCommandButton(@NotNull ActiveComponent button2) {
        this.myCommandButton = button2;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setCouldPin(@Nullable Processor<? super JBPopup> callback2) {
        this.myPinCallback = callback2;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setKeyboardActions(@NotNull List<? extends Pair<ActionListener, KeyStroke>> keyboardActions) {
        this.myKeyboardActions = keyboardActions;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setSettingButtons(@NotNull Component button2) {
        this.mySettingsButtons = button2;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnOtherWindowOpen(boolean cancelOnWindow) {
        this.myCancelOnWindow = cancelOnWindow;
        return this;
    }

    public ComponentPopupBuilder setCancelOnWindowDeactivation(boolean cancelOnWindowDeactivation) {
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setKeyEventHandler(@NotNull BooleanFunction<? super KeyEvent> handler2) {
        this.myKeyEventHandler = handler2;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setProject(Project project) {
        this.myProject = project;
        return this;
    }

    @NotNull
    public JBPopup createPopup() {
        AbstractPopup popup2 = new AbstractPopup().init(this.myProject, this.myComponent, this.myPreferredFocusedComponent, this.myRequestFocus, this.myFocusable, this.myMovable, this.myDimensionServiceKey, this.myResizable, this.myTitle, this.myCallback, this.myCancelOnClickOutside, this.myListeners, this.myUseDimServiceForXYLocation, this.myCommandButton, this.myCancelButton, this.myCancelOnMouseOutCallback, this.myCancelOnWindow, this.myTitleIcon, this.myCancelKeyEnabled, this.myLocateByContent, this.myPlaceWithinScreen, this.myMinSize, this.myAlpha, this.myMaskProvider, this.myInStack, this.myModalContext, this.myFocusOwners, this.myAd, this.myAdAlignment, false, this.myKeyboardActions, this.mySettingsButtons, this.myPinCallback, this.myMayBeParent, this.myShowShadow, this.myShowBorder, this.myBorderColor, this.myCancelOnWindowDeactivation, this.myKeyEventHandler);
        popup2.setNormalWindowLevel(this.myNormalWindowLevel);
        popup2.setOkHandler(this.myOkHandler);
        if (this.myUserData != null) {
            popup2.setUserData(this.myUserData);
        }
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)popup2);
        return popup2;
    }

    @NotNull
    public ComponentPopupBuilder setRequestFocusCondition(@NotNull Project project, @NotNull Condition<? super Project> condition) {
        this.myRequestFocus = condition.value((Object)project);
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setTitleIcon(@NotNull ActiveIcon icon2) {
        this.myTitleIcon = icon2;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setLocateByContent(boolean byContent) {
        this.myLocateByContent = byContent;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setLocateWithinScreenBounds(boolean within) {
        this.myPlaceWithinScreen = within;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setMinSize(Dimension minSize) {
        this.myMinSize = minSize;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setMaskProvider(MaskProvider maskProvider) {
        this.myMaskProvider = maskProvider;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setAlpha(float alpha) {
        this.myAlpha = alpha;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setBelongsToGlobalPopupStack(boolean isInStack) {
        this.myInStack = isInStack;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder addUserData(Object object) {
        if (this.myUserData == null) {
            this.myUserData = new ArrayList<Object>();
        }
        this.myUserData.add(object);
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setModalContext(boolean modal) {
        this.myModalContext = modal;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setFocusOwners(Component @NotNull [] focusOwners) {
        this.myFocusOwners = focusOwners;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setAdText(@Nullable String text) {
        return this.setAdText(text, 2);
    }

    @NotNull
    public ComponentPopupBuilder setAdText(@Nullable String text, int textAlignment) {
        this.myAd = text;
        this.myAdAlignment = textAlignment;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setShowShadow(boolean show2) {
        this.myShowShadow = show2;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setShowBorder(boolean show2) {
        this.myShowBorder = show2;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setNormalWindowLevel(boolean b) {
        this.myNormalWindowLevel = b;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setBorderColor(Color color) {
        this.myBorderColor = color;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setOkHandler(@Nullable Runnable okHandler) {
        this.myOkHandler = okHandler;
        return this;
    }
}

