/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.messages;

import com.intellij.BundleBase;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.ModalityHelper;
import com.intellij.ui.mac.MacMessagesEmulation;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.ui.messages.SheetMessage;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBMacMessages
extends MacMessagesEmulation {
    public int showYesNoCancelDialog(@NotNull String title, String message, @NotNull String defaultButton, String alternateButton, String otherButton, @Nullable Window window, @Nullable DialogWrapper.DoNotAskOption doNotAskOption) {
        int result2;
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        String defaultButtonCleaned = defaultButton.replace(BundleBase.MNEMONIC_STRING, "");
        String otherButtonCleaned = otherButton.replace(BundleBase.MNEMONIC_STRING, "");
        String alternateButtonCleaned = alternateButton.replace(BundleBase.MNEMONIC_STRING, "");
        SheetMessage sheetMessage = new SheetMessage(window, title, message, UIUtil.getQuestionIcon(), new String[]{defaultButtonCleaned, otherButtonCleaned, alternateButtonCleaned}, doNotAskOption, defaultButton, alternateButton);
        String resultString = sheetMessage.getResult();
        int n = resultString.equals(defaultButtonCleaned) ? 0 : (result2 = resultString.equals(alternateButtonCleaned) ? 1 : 2);
        if (doNotAskOption != null) {
            doNotAskOption.setToBeShown(sheetMessage.toBeShown(), result2);
        }
        return result2;
    }

    public int showMessageDialog(@NotNull String title, String message, String @NotNull [] buttons, boolean errorStyle, @Nullable Window window, int defaultOptionIndex, int focusedOptionIndex, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        Icon icon2 = errorStyle ? UIUtil.getErrorIcon() : UIUtil.getInformationIcon();
        String defaultOptionTitle = defaultOptionIndex != -1 ? buttons[defaultOptionIndex] : null;
        String focusedButtonTitle = focusedOptionIndex != -1 ? buttons[focusedOptionIndex] : null;
        SheetMessage sheetMessage = new SheetMessage(window, title, message, icon2, buttons, doNotAskDialogOption, defaultOptionTitle, focusedButtonTitle);
        String result2 = sheetMessage.getResult();
        for (int i2 = 0; i2 < buttons.length; ++i2) {
            if (!result2.equals(buttons[i2])) continue;
            if (doNotAskDialogOption != null) {
                doNotAskDialogOption.setToBeShown(sheetMessage.toBeShown(), i2);
            }
            return i2;
        }
        return -1;
    }

    public void showOkMessageDialog(@NotNull String title, String message, @NotNull String okText, @Nullable Window window) {
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        new SheetMessage(window, title, message, UIUtil.getInformationIcon(), new String[]{okText}, null, okText, okText);
    }

    public void showOkMessageDialog(@NotNull String title, String message, @NotNull String okText) {
        Window foremostWindow = JBMacMessages.getForemostWindow(null);
        new SheetMessage(foremostWindow, title, message, UIUtil.getInformationIcon(), new String[]{okText}, null, null, okText);
    }

    private static Window getForemostWindow(Window window) {
        Window _window = null;
        IdeFocusManager ideFocusManager = IdeFocusManager.getGlobalInstance();
        Component focusOwner = IdeFocusManager.findInstance().getFocusOwner();
        if (focusOwner != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window == null && (focusOwner = ideFocusManager.getLastFocusedFor(ideFocusManager.getLastFocusedIdeWindow())) != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window == null) {
            _window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (_window == null) {
            _window = WindowManager.getInstance().findVisibleFrame();
        }
        if (_window == null && window != null && (focusOwner = window.getMostRecentFocusOwner()) != null) {
            _window = SwingUtilities.getWindowAncestor(focusOwner);
        }
        if (_window != null && ModalityHelper.isModalBlocked(_window)) {
            _window = ModalityHelper.getModalBlockerFor(_window);
        }
        while (_window != null && MacUtil.getWindowTitle((Window)_window) == null) {
            _window = _window.getOwner();
        }
        while (Registry.is((String)"skip.untitled.windows.for.mac.messages") && _window instanceof JDialog && !((JDialog)_window).isModal()) {
            _window = _window.getOwner();
        }
        while (_window != null && _window.getParent() != null && WindowManager.getInstance().isNotSuggestAsParent(_window)) {
            _window = _window.getOwner();
        }
        return _window;
    }

    public int showYesNoDialog(@NotNull String title, String message, @NotNull String yesButton, @NotNull String noButton, @Nullable Window window) {
        SheetMessage sheetMessage;
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        return (sheetMessage = new SheetMessage(window, title, message, UIUtil.getQuestionIcon(), new String[]{yesButton, noButton}, null, yesButton, noButton)).getResult().equals(yesButton) ? 0 : 1;
    }

    public int showYesNoDialog(@NotNull String title, String message, @NotNull String yesButton, @NotNull String noButton, @Nullable Window window, @Nullable DialogWrapper.DoNotAskOption doNotAskDialogOption) {
        SheetMessage sheetMessage;
        int result2;
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        int n = result2 = (sheetMessage = new SheetMessage(window, title, message, UIUtil.getQuestionIcon(), new String[]{yesButton, noButton}, doNotAskDialogOption, yesButton, noButton)).getResult().equals(yesButton) ? 0 : 1;
        if (doNotAskDialogOption != null && (result2 == 0 || doNotAskDialogOption.shouldSaveOptionsOnCancel())) {
            doNotAskDialogOption.setToBeShown(sheetMessage.toBeShown(), result2);
        }
        return result2;
    }

    public void showErrorDialog(@NotNull String title, String message, @NotNull String okButton, @Nullable Window window) {
        if (window == null) {
            window = JBMacMessages.getForemostWindow(null);
        }
        new SheetMessage(window, title, message, UIUtil.getErrorIcon(), new String[]{okButton}, null, null, okButton);
    }
}

