/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.application.impl.ModalityStateEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.TouchbarDataKeys;
import com.intellij.ui.mac.foundation.NSDefaults;
import com.intellij.ui.mac.touchbar.BarContainer;
import com.intellij.ui.mac.touchbar.BarType;
import com.intellij.ui.mac.touchbar.BuildUtils;
import com.intellij.ui.mac.touchbar.NST;
import com.intellij.ui.mac.touchbar.ProjectData;
import com.intellij.ui.mac.touchbar.StackTouchBars;
import com.intellij.ui.mac.touchbar.TouchBar;
import com.intellij.ui.mac.touchbar.Utils;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.Predicate;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.InputEvent;
import java.awt.event.MouseWheelEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TouchBarsManager {
    private static final Logger LOG = Logger.getInstance(TouchBarsManager.class);
    private static final StackTouchBars ourStack = new StackTouchBars();
    private static final Object ourLoadNstSync = new Object();
    private static final Map<Project, ProjectData> ourProjectData = new HashMap<Project, ProjectData>();
    private static final Map<Container, BarContainer> ourTemporaryBars = new HashMap<Container, BarContainer>();
    private static volatile boolean isInitialized;
    private static volatile boolean isEnabled;
    private static final String RUNNERS_GROUP_TOUCHBAR = "RunnerActionsTouchbar";

    public static void onApplicationInitialized() {
        TouchBarsManager.initialize();
        if (!isInitialized || !TouchBarsManager.isTouchBarEnabled()) {
            return;
        }
        for (Project project : ProjectUtil.getOpenProjects()) {
            TouchBarsManager.registerProject(project);
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        for (Editor editor : editorFactory.getAllEditors()) {
            TouchBarsManager.registerEditor(editor);
        }
        editorFactory.addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                TouchBarsManager.registerEditor(event.getEditor());
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                TouchBarsManager.releaseEditor(event.getEditor());
            }
        }, (Disposable)ApplicationManager.getApplication());
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

            public void projectOpened(@NotNull Project project) {
                TouchBarsManager.registerProject(project);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void projectClosed(@NotNull Project project) {
                ApplicationManager.getApplication().assertIsDispatchThread();
                Map map2 = ourProjectData;
                synchronized (map2) {
                    ProjectData projectData2 = (ProjectData)ourProjectData.remove(project);
                    if (projectData2 == null) {
                        LOG.error("project data already was removed: " + project);
                        return;
                    }
                    ourStack.removeAll(projectData2.getAllContainers());
                    projectData2.releaseAll();
                }
            }
        });
        ActionManager actionManager = (ActionManager)ApplicationManager.getApplication().getServiceIfCreated(ActionManager.class);
        if (actionManager == null) {
            NonUrgentExecutor.getInstance().execute(() -> TouchBarsManager.initExecutorGroup(ActionManager.getInstance()));
        } else {
            TouchBarsManager.initExecutorGroup(actionManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerProject(final @NotNull Project project) {
        if (project.isDisposed()) {
            return;
        }
        ProjectData projectData2 = new ProjectData(project);
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ProjectData prev = ourProjectData.put(project, projectData2);
            if (prev != null) {
                LOG.error("previous project data wasn't removed: " + project);
                prev.releaseAll();
            }
        }
        StartupManager.getInstance((Project)project).runAfterOpened(() -> projectData2.get(BarType.DEFAULT).show());
        project.getMessageBus().connect().subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2) {
                ApplicationManager.getApplication().invokeLater(() -> TouchBarsManager._updateTouchbar(project));
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler2, int exitCode) {
                String toolWindowId = env.getExecutor().getToolWindowId();
                ourStack.pop((Condition<? super BarContainer>)((Condition)topContainer -> {
                    if (topContainer.getType() != BarType.DEBUGGER) {
                        return false;
                    }
                    if (!("Debug".equals(toolWindowId) || "Run Dashboard".equals(toolWindowId) || "Services".equals(toolWindowId))) {
                        return false;
                    }
                    return !TouchBarsManager._hasAnyActiveSession(project, handler2);
                }));
                ApplicationManager.getApplication().invokeLater(() -> TouchBarsManager._updateTouchbar(project));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        if (isInitialized) {
            return;
        }
        Object object = ourLoadNstSync;
        synchronized (object) {
            if (isInitialized) {
                return;
            }
            NST.initialize();
            String appId = Utils.getAppId();
            if (appId == null || appId.isEmpty()) {
                LOG.debug("can't obtain application id from NSBundle");
            } else if (NSDefaults.isShowFnKeysEnabled((String)appId)) {
                LOG.info("nst library was loaded, but user enabled fn-keys in touchbar");
                isEnabled = false;
            }
            isInitialized = true;
        }
    }

    public static boolean isTouchBarAvailable() {
        return SystemInfo.isMac && NST.isAvailable();
    }

    public static boolean isTouchBarEnabled() {
        return TouchBarsManager.isTouchBarAvailable() && isEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reloadAll() {
        if (!isInitialized || !TouchBarsManager.isTouchBarEnabled()) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ourProjectData.forEach((p, pd) -> pd.reloadAll());
        }
        ourStack.setTouchBarFromTopContainer();
    }

    public static void onInputEvent(InputEvent e) {
        if (!isInitialized || !TouchBarsManager.isTouchBarEnabled()) {
            return;
        }
        if (e instanceof MouseWheelEvent) {
            return;
        }
        ourStack.updateKeyMask((long)e.getModifiersEx() & ProjectData.getUsedKeyMask());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onFocusEvent(AWTEvent e) {
        if (!TouchBarsManager.isTouchBarEnabled()) {
            return;
        }
        if (!(e.getSource() instanceof Container)) {
            return;
        }
        Container src = (Container)e.getSource();
        if (e.getID() == 1004) {
            Object barForParent;
            if (TouchBarsManager._hasPopup()) {
                return;
            }
            if (TouchBarsManager._hasNonModalDialog() && (barForParent = TouchBarsManager._findByParentComponent(src, ourTemporaryBars.values(), null)) != null) {
                ((BarContainer)barForParent).show();
                return;
            }
            barForParent = ourProjectData;
            synchronized (barForParent) {
                for (ProjectData pd : ourProjectData.values()) {
                    if (pd.isDisposed()) continue;
                    if (pd.checkToolWindowContents(src)) {
                        return;
                    }
                    ProjectData.EditorData ed = pd.findEditorDataByComponent(src);
                    if (ed != null && ed.containerSearch != null) {
                        ourStack.showContainer(ed.containerSearch);
                        return;
                    }
                    BarContainer toolWindow = pd.findDebugToolWindowByComponent(src);
                    if (toolWindow == null) continue;
                    ourStack.showContainer(toolWindow);
                    return;
                }
            }
        }
        if (e.getID() == 1005) {
            BarContainer nonModalDialogParent = TouchBarsManager._findByParentComponent(src, ourTemporaryBars.values(), (Predicate<? super BarContainer>)((Predicate)bc -> bc.isNonModalDialog()));
            if (nonModalDialogParent != null) {
                nonModalDialogParent.hide();
                return;
            }
            Map<Project, ProjectData> map2 = ourProjectData;
            synchronized (map2) {
                for (ProjectData pd : ourProjectData.values()) {
                    ProjectData.EditorData ed;
                    if (pd.isDisposed() || (ed = pd.findEditorDataByComponent(src)) == null || ed.containerSearch == null) continue;
                    ourStack.removeContainer(ed.containerSearch);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerEditor(@NotNull Editor editor) {
        ProjectData projectData2;
        Project project = editor.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            projectData2 = ourProjectData.get(project);
            if (projectData2 == null) {
                return;
            }
            projectData2.registerEditor(editor);
        }
        if (editor instanceof EditorEx) {
            ((EditorEx)editor).addFocusListener(new FocusChangeListener(){

                @Override
                public void focusGained(@NotNull Editor editor) {
                    projectData2.get(BarType.DEFAULT).setOptionalContextVisible(null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void releaseEditor(@NotNull Editor editor) {
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ProjectData pd = ourProjectData.get(project);
            if (pd == null) {
                return;
            }
            pd.removeEditor(editor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onUpdateEditorHeader(@NotNull Editor editor, JComponent header2) {
        if (!isInitialized || !TouchBarsManager.isTouchBarEnabled()) {
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Map<Project, ProjectData> map2 = ourProjectData;
        synchronized (map2) {
            ActionGroup actions;
            ProjectData projectData2 = ourProjectData.get(project);
            if (projectData2 == null) {
                LOG.error("can't find project data to update header of editor: " + editor + ", project: " + project);
                return;
            }
            ProjectData.EditorData editorData = projectData2.getEditorData(editor);
            if (editorData == null) {
                LOG.error("can't find editor-data to update header of editor: " + editor + ", project: " + project);
                return;
            }
            ActionGroup actionGroup = actions = header2 instanceof DataProvider ? (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData((DataProvider)header2) : null;
            if (header2 == null) {
                editorData.editorHeader = null;
                if (editorData.containerSearch != null) {
                    ourStack.removeContainer(editorData.containerSearch);
                }
            } else {
                editorData.editorHeader = header2;
                if (editorData.containerSearch == null || editorData.actionsSearch != actions) {
                    if (editorData.containerSearch != null) {
                        ourStack.removeContainer(editorData.containerSearch);
                        editorData.containerSearch.release();
                    }
                    if (actions != null) {
                        editorData.containerSearch = new BarContainer(BarType.EDITOR_SEARCH, BuildUtils.buildFromGroup("editor_search_" + header2, actions, true, true), null, header2);
                        ourStack.showContainer(editorData.containerSearch);
                    }
                }
            }
        }
    }

    @Nullable
    public static Disposable showPopupBar(@NotNull JBPopup popup2, @NotNull JComponent popupComponent) {
        if (!TouchBarsManager.isTouchBarEnabled()) {
            return null;
        }
        if (!(popup2 instanceof ListPopupImpl)) {
            return null;
        }
        @NotNull ListPopupImpl listPopup = (ListPopupImpl)popup2;
        if (!(listPopup.getList().getCellRenderer() instanceof PopupListElementRenderer)) {
            return null;
        }
        TouchBar tb = BuildUtils.createScrubberBarFromPopup(listPopup);
        BarContainer container2 = new BarContainer(BarType.POPUP, tb, null, popupComponent);
        ourTemporaryBars.put(popupComponent, container2);
        ourStack.showContainer(container2);
        return () -> {
            ourStack.removeContainer(container2);
            ourTemporaryBars.remove(popupComponent);
            container2.release();
        };
    }

    @Nullable
    public static Disposable showDialogWrapperButtons(@NotNull Container contentPane) {
        if (!TouchBarsManager.isTouchBarEnabled()) {
            return null;
        }
        HashMap<TouchbarDataKeys.DlgButtonDesc, JButton> buttonMap = new HashMap<TouchbarDataKeys.DlgButtonDesc, JButton>();
        HashMap<Component, ActionGroup> actions = new HashMap<Component, ActionGroup>();
        TouchBarsManager._findAllTouchbarProviders(actions, buttonMap, contentPane);
        if (buttonMap.isEmpty() && actions.isEmpty()) {
            return null;
        }
        boolean replaceEsc = false;
        boolean emulateEsc = false;
        if (!actions.isEmpty()) {
            ActionGroup actionGroup = (ActionGroup)actions.values().iterator().next();
            TouchbarDataKeys.ActionDesc groupDesc = (TouchbarDataKeys.ActionDesc)actionGroup.getTemplatePresentation().getClientProperty(TouchbarDataKeys.ACTIONS_DESCRIPTOR_KEY);
            replaceEsc = groupDesc == null || groupDesc.isReplaceEsc();
            emulateEsc = true;
        }
        TouchBar touchBar = new TouchBar("dialog_buttons", replaceEsc, false, emulateEsc, null, null);
        BuildUtils.addDialogButtons(touchBar, buttonMap, actions);
        ModalityStateEx modalityState = LaterInvocator.getCurrentModalityState();
        BarType barType = ModalityState.NON_MODAL.equals((Object)modalityState) ? BarType.DIALOG : BarType.MODAL_DIALOG;
        BarContainer barContainer = new BarContainer(barType, touchBar, null, contentPane);
        ourTemporaryBars.put(contentPane, barContainer);
        ourStack.showContainer(barContainer);
        return () -> {
            ourTemporaryBars.remove(contentPane);
            ourStack.removeContainer(barContainer);
            barContainer.release();
        };
    }

    public static void showStopRunningBar(List<? extends Pair<RunContentDescriptor, Runnable>> stoppableDescriptors) {
        TouchBar tb = BuildUtils.createStopRunningBar(stoppableDescriptors);
        BarContainer container2 = new BarContainer(BarType.DIALOG, tb, null, null);
        container2.setOnHideCallback(() -> container2.release());
        ourStack.showContainer(container2);
    }

    static void showContainer(@NotNull BarContainer container2) {
        ourStack.showContainer(container2);
    }

    static void hideContainer(@NotNull BarContainer container2) {
        ourStack.removeContainer(container2);
    }

    private static boolean _hasAnyActiveSession(Project project, ProcessHandler handler2) {
        for (ProcessHandler h : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (h == null || h == handler2 || h.isProcessTerminated() || h.isProcessTerminating()) continue;
            return true;
        }
        return false;
    }

    private static boolean _hasPopup() {
        return ourTemporaryBars.values().stream().anyMatch(bc -> bc.isPopup());
    }

    private static boolean _hasNonModalDialog() {
        return ourTemporaryBars.values().stream().anyMatch(bc -> bc.isNonModalDialog());
    }

    private static BarContainer _findByParentComponent(Container child2, Collection<? extends BarContainer> candidates, Predicate<? super BarContainer> filter2) {
        for (BarContainer barContainer : candidates) {
            if (filter2 != null && !filter2.apply((Object)barContainer) || barContainer.getParentComponent() == null || !SwingUtilities.isDescendingFrom(child2, barContainer.getParentComponent())) continue;
            return barContainer;
        }
        return null;
    }

    private static void _findAllTouchbarProviders(@NotNull Map<Component, ActionGroup> out, @NotNull Map<TouchbarDataKeys.DlgButtonDesc, JButton> out2, @NotNull Container root) {
        JBIterable iter = ((JBTreeTraverser)UIUtil.uiTraverser((Component)root).expandAndFilter(c -> c.isVisible())).traverse();
        for (Component component2 : iter) {
            ActionGroup actions;
            TouchbarDataKeys.DlgButtonDesc desc;
            if (component2 instanceof JButton && (desc = (TouchbarDataKeys.DlgButtonDesc)UIUtil.getClientProperty((Object)component2, (Key)TouchbarDataKeys.DIALOG_BUTTON_DESCRIPTOR_KEY)) != null) {
                out2.put(desc, (JButton)component2);
            }
            DataProvider dp = null;
            if (component2 instanceof DataProvider) {
                dp = (DataProvider)component2;
            } else if (component2 instanceof JComponent) {
                dp = DataManager.getDataProvider((JComponent)((JComponent)component2));
            }
            if (dp == null || (actions = (ActionGroup)TouchbarDataKeys.ACTIONS_KEY.getData(dp)) == null) continue;
            out.put(component2, actions);
        }
    }

    private static void _updateTouchbar(@NotNull Project project) {
        TouchBar top;
        BarContainer tobForProject = ourStack.findTopProjectContainer(project);
        if (tobForProject != null) {
            TouchBarsManager.showContainer(tobForProject);
        }
        if ((top = ourStack.getTopTouchBar()) != null) {
            top.updateActionItems();
        }
    }

    private static void initExecutorGroup(@NotNull ActionManager actionManager) {
        AnAction runButtons = actionManager.getAction(RUNNERS_GROUP_TOUCHBAR);
        if (runButtons == null) {
            return;
        }
        if (!(runButtons instanceof DefaultActionGroup)) {
            return;
        }
        DefaultActionGroup group = (DefaultActionGroup)runButtons;
        for (Executor executor : Executor.EXECUTOR_EXTENSION_NAME.getExtensionList()) {
            if (!executor.getId().equals("Run") && !executor.getId().equals("Debug")) continue;
            group.add(actionManager.getAction(executor.getId()), actionManager);
        }
    }

    static {
        isEnabled = true;
    }
}

