/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.SpacingItem;
import com.intellij.ui.mac.touchbar.TBItem;
import com.intellij.ui.mac.touchbar.TBItemAnActionButton;
import com.intellij.ui.mac.touchbar.TBItemGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ItemsContainer {
    @NotNull
    private final String myName;
    @NotNull
    private final List<TBItem> myItems = new ArrayList<TBItem>();
    private long myCounter = 0L;

    ItemsContainer(@NotNull String name) {
        this.myName = name;
    }

    boolean isEmpty() {
        return this.myItems.isEmpty();
    }

    boolean hasAnActionItems() {
        return this.anyMatchDeep(item -> item instanceof TBItemAnActionButton);
    }

    public String toString() {
        return this.myName;
    }

    void addItem(@NotNull TBItem item) {
        this.addItem(item, -1);
    }

    void addItem(@NotNull TBItem item, int index) {
        if (item.getUid() == null || item.getUid().isEmpty()) {
            item.setUid(this._genNewID(item.getName()));
        }
        if (index >= 0 && index < this.myItems.size()) {
            this.myItems.add(index, item);
        } else {
            this.myItems.add(item);
        }
    }

    void addItem(@NotNull TBItem item, @Nullable TBItem positionAnchor) {
        int index = positionAnchor != null ? this.myItems.indexOf(positionAnchor) : -1;
        this.addItem(item, index);
    }

    void addSpacing(boolean large) {
        this.addSpacing(large, -1);
    }

    void addSpacing(boolean large, int index) {
        SpacingItem spacing = new SpacingItem();
        spacing.setUid(large ? "static_touchbar_item_large_space" : "static_touchbar_item_small_space");
        if (index >= 0 && index < this.myItems.size()) {
            this.myItems.add(index, spacing);
        } else {
            this.myItems.add(spacing);
        }
    }

    void addFlexibleSpacing() {
        this.addFlexibleSpacing(-1);
    }

    void addFlexibleSpacing(int index) {
        SpacingItem spacing = new SpacingItem();
        spacing.setUid("static_touchbar_item_flexible_space");
        if (index >= 0 && index < this.myItems.size()) {
            this.myItems.add(index, spacing);
        } else {
            this.myItems.add(spacing);
        }
    }

    void releaseAll() {
        this.myItems.forEach(item -> item.releaseNativePeer());
        this.myItems.clear();
    }

    void remove(@Nullable Predicate<TBItem> filter2) {
        if (filter2 == null) {
            this.releaseAll();
            return;
        }
        Iterator<TBItem> i2 = this.myItems.iterator();
        while (i2.hasNext()) {
            @NotNull TBItem item = i2.next();
            boolean removeGroup = false;
            if (item instanceof TBItemGroup) {
                ItemsContainer group = ((TBItemGroup)item).getContainer();
                group.remove(filter2);
                if (group.isEmpty()) {
                    removeGroup = true;
                }
            }
            if (!removeGroup && !filter2.test(item)) continue;
            item.releaseNativePeer();
            i2.remove();
        }
    }

    @NotNull
    @NotNull String @NotNull [] getVisibleIds() {
        String[] ids = new String[this.myItems.size()];
        int c = 0;
        for (TBItem item : this.myItems) {
            if (!item.myIsVisible) continue;
            ids[c++] = item.getUid();
        }
        return c == this.myItems.size() ? ids : Arrays.copyOf(ids, c);
    }

    ID @NotNull [] getVisibleNativePeers() {
        ID[] ids = new ID[this.myItems.size()];
        int c = 0;
        for (TBItem item : this.myItems) {
            if (!item.myIsVisible || ID.NIL.equals((Object)item.getNativePeer())) continue;
            ids[c++] = item.getNativePeer();
        }
        return c == this.myItems.size() ? ids : Arrays.copyOf(ids, c);
    }

    void softClear(@NotNull Map<AnAction, TBItemAnActionButton> actPool, @NotNull LinkedList<TBItemGroup> groupPool) {
        this.myItems.forEach(item -> {
            if (item instanceof TBItemAnActionButton) {
                TBItemAnActionButton actItem = (TBItemAnActionButton)item;
                actPool.put(actItem.getAnAction(), actItem);
            }
            if (item instanceof TBItemGroup) {
                TBItemGroup group = (TBItemGroup)item;
                group.getContainer().softClear(actPool, groupPool);
                groupPool.add(group);
            }
        });
        this.myItems.clear();
    }

    TBItem getItem(int index) {
        return index >= 0 && index < this.myItems.size() ? this.myItems.get(index) : null;
    }

    void forEachDeep(Consumer<? super TBItem> proc) {
        this.myItems.forEach(item -> {
            if (item instanceof TBItemGroup) {
                ((TBItemGroup)item).getContainer().forEachDeep(proc);
                return;
            }
            proc.accept((TBItem)item);
        });
    }

    boolean anyMatchDeep(Predicate<? super TBItem> proc) {
        return this.myItems.stream().anyMatch(item -> {
            if (item instanceof TBItemGroup) {
                return ((TBItemGroup)item).getContainer().anyMatchDeep(proc);
            }
            return proc.test((TBItem)item);
        });
    }

    int releaseItems(Predicate<? super TBItem> proc) {
        Iterator<TBItem> i2 = this.myItems.iterator();
        int count = 0;
        while (i2.hasNext()) {
            TBItem tbi = i2.next();
            if (!proc.test(tbi)) continue;
            ++count;
            i2.remove();
            tbi.releaseNativePeer();
        }
        return count;
    }

    @Nullable
    TBItem findItem(String uid) {
        for (TBItem item : this.myItems) {
            if (!item.getUid().equals(uid)) continue;
            return item;
        }
        return null;
    }

    @NotNull
    private String _genNewID(String desc) {
        return String.format("%s.%s.%d", this.myName, desc, this.myCounter++);
    }
}

