/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.jcef;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.jcef.JBCefApp;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.ui.jcef.JBCefClient;
import com.intellij.util.ObjectUtils;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JCEFHtmlPanel
extends JBCefBrowser {
    private static final JBCefClient ourCefClient = JBCefApp.getInstance().createClient();
    @NotNull
    private final String myUrl;

    public JCEFHtmlPanel(@Nullable String url) {
        this(ourCefClient, url);
    }

    public JCEFHtmlPanel(JBCefClient client, String url) {
        super(client, null);
        this.myUrl = (String)ObjectUtils.notNull((Object)url, (Object)"about:blank");
        if (client != ourCefClient) {
            Disposer.register((Disposable)this, (Disposable)client);
        }
    }

    protected JBCefBrowser.DefaultCefContextMenuHandler createDefaultContextMenuHandler() {
        boolean isInternal = ApplicationManager.getApplication().isInternal();
        return new JBCefBrowser.DefaultCefContextMenuHandler(isInternal){

            public void onBeforeContextMenu(CefBrowser browser2, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
                model.clear();
                super.onBeforeContextMenu(browser2, frame, params, model);
            }
        };
    }

    public void setHtml(@NotNull String html) {
        String htmlToRender = this.prepareHtml(html);
        this.loadHTML(htmlToRender, this.myUrl);
    }

    @NotNull
    protected String prepareHtml(@NotNull String html) {
        return html;
    }

    static {
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)ourCefClient);
    }
}

