/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.colorpicker;

import com.intellij.ui.colorpicker.AlphaFormat;
import com.intellij.ui.colorpicker.ButtonPanel;
import com.intellij.ui.colorpicker.ColorDocument;
import com.intellij.ui.colorpicker.ColorFormat;
import com.intellij.ui.colorpicker.ColorLabel;
import com.intellij.ui.colorpicker.ColorPickerBuilderKt;
import com.intellij.ui.colorpicker.ColorPickerModel;
import com.intellij.ui.colorpicker.ColorValueField;
import com.intellij.ui.colorpicker.ColorValuePanel;
import com.intellij.ui.colorpicker.ColorValuePanel$WhenMappings;
import com.intellij.ui.colorpicker.ColorValuePanelKt;
import com.intellij.ui.colorpicker.DigitColorDocument;
import com.intellij.ui.colorpicker.HexColorDocument;
import com.intellij.ui.picker.ColorListener;
import com.intellij.util.Alarm;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.Arrays;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.math.MathKt;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 S2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001SB\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u001a\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0010\u0010F\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010G\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010H\u001a\u00020\u0007H\u0016J\u0010\u0010I\u001a\u00020>2\u0006\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020>H\u0002J\b\u0010M\u001a\u00020>H\u0002J\u0012\u0010N\u001a\u00020>2\b\u0010J\u001a\u0004\u0018\u00010KH\u0002J\u001a\u0010O\u001a\u00020>2\u0006\u0010B\u001a\u00020C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J \u0010P\u001a\u00020>*\u00020K2\b\u0010Q\u001a\u0004\u0018\u00010R2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00020\u000e8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0013\u0010\u001a\u001a\u00020\u000e8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0010R\u0013\u0010\u001c\u001a\u00020\u000e8F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0010R\u0011\u0010\u001e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\fR\u000e\u0010 \u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010%\u001a\u00020$2\u0006\u0010#\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R+\u0010-\u001a\u00020,2\u0006\u0010#\u001a\u00020,8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b2\u0010+\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u00103\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00104\u001a\u00020\u000e8F\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0010R\u000e\u00106\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u00109\u001a\u00020:8F\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006T"}, d2={"Lcom/intellij/ui/colorpicker/ColorValuePanel;", "Ljavax/swing/JPanel;", "Ljavax/swing/event/DocumentListener;", "Lcom/intellij/ui/picker/ColorListener;", "model", "Lcom/intellij/ui/colorpicker/ColorPickerModel;", "showAlpha", "", "(Lcom/intellij/ui/colorpicker/ColorPickerModel;Z)V", "alphaButtonPanel", "Lcom/intellij/ui/colorpicker/ButtonPanel;", "getAlphaButtonPanel", "()Lcom/intellij/ui/colorpicker/ButtonPanel;", "alphaField", "Lcom/intellij/ui/colorpicker/ColorValueField;", "getAlphaField", "()Lcom/intellij/ui/colorpicker/ColorValueField;", "alphaHexDocument", "Lcom/intellij/ui/colorpicker/DigitColorDocument;", "alphaLabel", "Lcom/intellij/ui/colorpicker/ColorLabel;", "alphaPercentageDocument", "blueDocument", "brightnessDocument", "colorField1", "getColorField1", "colorField2", "getColorField2", "colorField3", "getColorField3", "colorFormatButtonPanel", "getColorFormatButtonPanel", "colorLabel1", "colorLabel2", "colorLabel3", "<set-?>", "Lcom/intellij/ui/colorpicker/AlphaFormat;", "currentAlphaFormat", "getCurrentAlphaFormat", "()Lcom/intellij/ui/colorpicker/AlphaFormat;", "setCurrentAlphaFormat", "(Lcom/intellij/ui/colorpicker/AlphaFormat;)V", "currentAlphaFormat$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lcom/intellij/ui/colorpicker/ColorFormat;", "currentColorFormat", "getCurrentColorFormat", "()Lcom/intellij/ui/colorpicker/ColorFormat;", "setCurrentColorFormat", "(Lcom/intellij/ui/colorpicker/ColorFormat;)V", "currentColorFormat$delegate", "greenDocument", "hexField", "getHexField", "hueDocument", "redDocument", "saturationDocument", "updateAlarm", "Lcom/intellij/util/Alarm;", "getUpdateAlarm", "()Lcom/intellij/util/Alarm;", "changedUpdate", "", "e", "Ljavax/swing/event/DocumentEvent;", "colorChanged", "color", "Ljava/awt/Color;", "source", "", "insertUpdate", "removeUpdate", "requestFocusInWindow", "update", "src", "Ljavax/swing/JTextField;", "updateAlphaFormat", "updateColorFormat", "updateColorToColorModel", "updateTextField", "setTextIfNeeded", "newText", "", "Companion", "intellij.platform.ide.impl"})
public final class ColorValuePanel
extends JPanel
implements DocumentListener,
ColorListener {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Alarm updateAlarm;
    @NotNull
    private final ColorValueField alphaField;
    private final DigitColorDocument alphaHexDocument;
    private final DigitColorDocument alphaPercentageDocument;
    @NotNull
    private final ColorValueField hexField;
    private final ColorLabel alphaLabel;
    private final ColorLabel colorLabel1;
    private final ColorLabel colorLabel2;
    private final ColorLabel colorLabel3;
    @NotNull
    private final ButtonPanel alphaButtonPanel;
    @NotNull
    private final ButtonPanel colorFormatButtonPanel;
    @NotNull
    private final ColorValueField colorField1;
    private final DigitColorDocument redDocument;
    private final DigitColorDocument hueDocument;
    @NotNull
    private final ColorValueField colorField2;
    private final DigitColorDocument greenDocument;
    private final DigitColorDocument saturationDocument;
    @NotNull
    private final ColorValueField colorField3;
    private final DigitColorDocument blueDocument;
    private final DigitColorDocument brightnessDocument;
    @NotNull
    private final ReadWriteProperty currentAlphaFormat$delegate;
    @NotNull
    private final ReadWriteProperty currentColorFormat$delegate;
    private final ColorPickerModel model;
    private final boolean showAlpha;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ColorValuePanel.class), "currentAlphaFormat", "getCurrentAlphaFormat()Lcom/intellij/ui/colorpicker/AlphaFormat;")), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ColorValuePanel.class), "currentColorFormat", "getCurrentColorFormat()Lcom/intellij/ui/colorpicker/ColorFormat;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final Alarm getUpdateAlarm() {
        return this.updateAlarm;
    }

    @NotNull
    public final ColorValueField getAlphaField() {
        return this.alphaField;
    }

    @NotNull
    public final ColorValueField getHexField() {
        return this.hexField;
    }

    @NotNull
    public final ButtonPanel getAlphaButtonPanel() {
        return this.alphaButtonPanel;
    }

    @NotNull
    public final ButtonPanel getColorFormatButtonPanel() {
        return this.colorFormatButtonPanel;
    }

    @NotNull
    public final ColorValueField getColorField1() {
        return this.colorField1;
    }

    @NotNull
    public final ColorValueField getColorField2() {
        return this.colorField2;
    }

    @NotNull
    public final ColorValueField getColorField3() {
        return this.colorField3;
    }

    @NotNull
    public final AlphaFormat getCurrentAlphaFormat() {
        return (AlphaFormat)((Object)this.currentAlphaFormat$delegate.getValue((Object)this, $$delegatedProperties[0]));
    }

    public final void setCurrentAlphaFormat(@NotNull AlphaFormat alphaFormat) {
        this.currentAlphaFormat$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)alphaFormat);
    }

    @NotNull
    public final ColorFormat getCurrentColorFormat() {
        return (ColorFormat)((Object)this.currentColorFormat$delegate.getValue((Object)this, $$delegatedProperties[1]));
    }

    public final void setCurrentColorFormat(@NotNull ColorFormat colorFormat) {
        this.currentColorFormat$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)colorFormat);
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.colorField1.requestFocusInWindow();
    }

    private final void updateAlphaFormat() {
        switch (ColorValuePanel$WhenMappings.$EnumSwitchMapping$0[this.getCurrentAlphaFormat().ordinal()]) {
            case 1: {
                this.alphaLabel.setText("A");
                this.alphaField.setDocument(this.alphaHexDocument);
                this.alphaField.setText(String.valueOf(this.model.getAlpha()));
                break;
            }
            case 2: {
                this.alphaLabel.setText("A%");
                this.alphaField.setDocument(this.alphaPercentageDocument);
                this.alphaField.setText(String.valueOf(MathKt.roundToInt((float)((float)this.model.getAlpha() * 100.0f / (float)255))));
                break;
            }
        }
        this.updateAlarm.cancelAllRequests();
        this.repaint();
    }

    private final void updateColorFormat() {
        switch (ColorValuePanel$WhenMappings.$EnumSwitchMapping$1[this.getCurrentColorFormat().ordinal()]) {
            case 1: {
                this.colorLabel1.setText("R");
                this.colorLabel2.setText("G");
                this.colorLabel3.setText("B");
                this.colorField1.setDocument(this.redDocument);
                this.colorField2.setDocument(this.greenDocument);
                this.colorField3.setDocument(this.blueDocument);
                this.colorField1.setText(String.valueOf(this.model.getRed()));
                this.colorField2.setText(String.valueOf(this.model.getGreen()));
                this.colorField3.setText(String.valueOf(this.model.getBlue()));
                break;
            }
            case 2: {
                this.colorLabel1.setText("H\u00b0");
                this.colorLabel2.setText("S%");
                this.colorLabel3.setText("B%");
                this.colorField1.setDocument(this.hueDocument);
                this.colorField2.setDocument(this.saturationDocument);
                this.colorField3.setDocument(this.brightnessDocument);
                this.colorField1.setText(String.valueOf(MathKt.roundToInt((float)(this.model.getHue() * (float)360))));
                this.colorField2.setText(String.valueOf(MathKt.roundToInt((float)(this.model.getSaturation() * (float)100))));
                this.colorField3.setText(String.valueOf(MathKt.roundToInt((float)(this.model.getBrightness() * (float)100))));
                break;
            }
        }
        this.updateAlarm.cancelAllRequests();
        this.repaint();
    }

    public void colorChanged(@NotNull Color color, @Nullable Object source) {
        this.updateTextField(color, source);
    }

    private final void updateTextField(Color color, Object source) {
        if (this.getCurrentAlphaFormat() == AlphaFormat.BYTE) {
            this.setTextIfNeeded(this.alphaField, String.valueOf(color.getAlpha()), source);
        } else {
            this.setTextIfNeeded(this.alphaField, String.valueOf(MathKt.roundToInt((float)((float)color.getAlpha() * 100.0f / (float)255))), source);
        }
        if (this.getCurrentColorFormat() == ColorFormat.RGB) {
            this.setTextIfNeeded(this.colorField1, String.valueOf(color.getRed()), source);
            this.setTextIfNeeded(this.colorField2, String.valueOf(color.getGreen()), source);
            this.setTextIfNeeded(this.colorField3, String.valueOf(color.getBlue()), source);
        } else {
            float[] hsb = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
            this.setTextIfNeeded(this.colorField1, String.valueOf(MathKt.roundToInt((float)(hsb[0] * (float)360))), source);
            this.setTextIfNeeded(this.colorField2, String.valueOf(MathKt.roundToInt((float)(hsb[1] * (float)100))), source);
            this.setTextIfNeeded(this.colorField3, String.valueOf(MathKt.roundToInt((float)(hsb[2] * (float)100))), source);
        }
        Object object = StringCompanionObject.INSTANCE;
        String string = "%08X";
        Object[] objectArray = new Object[]{color.getRGB()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String hexStr = string2;
        if (!this.showAlpha) {
            object = hexStr;
            int n = 2;
            boolean bl2 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = ((String)object2).substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            hexStr = string3;
        }
        this.setTextIfNeeded(this.hexField, hexStr, source);
        this.updateAlarm.cancelAllRequests();
    }

    private final void setTextIfNeeded(JTextField $this$setTextIfNeeded, String newText, Object source) {
        if (Intrinsics.areEqual((Object)$this$setTextIfNeeded.getText(), (Object)newText) ^ true && (Intrinsics.areEqual((Object)source, (Object)this) ^ true || !$this$setTextIfNeeded.isFocusOwner())) {
            $this$setTextIfNeeded.setText(newText);
        }
    }

    @Override
    public void insertUpdate(@NotNull DocumentEvent e) {
        Document document = e.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.colorpicker.ColorDocument");
        }
        this.update(((ColorDocument)document).getSrc$intellij_platform_ide_impl());
    }

    @Override
    public void removeUpdate(@NotNull DocumentEvent e) {
        Document document = e.getDocument();
        if (document == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.ui.colorpicker.ColorDocument");
        }
        this.update(((ColorDocument)document).getSrc$intellij_platform_ide_impl());
    }

    @Override
    public void changedUpdate(@NotNull DocumentEvent e) {
    }

    private final void update(JTextField src) {
        this.updateAlarm.cancelAllRequests();
        this.updateAlarm.addRequest(new Runnable(this, src){
            final /* synthetic */ ColorValuePanel this$0;
            final /* synthetic */ JTextField $src;

            public final void run() {
                ColorValuePanel.access$updateColorToColorModel(this.this$0, this.$src);
            }
            {
                this.this$0 = colorValuePanel;
                this.$src = jTextField;
            }
        }, 300);
    }

    private final void updateColorToColorModel(JTextField src) {
        Color color;
        if (Intrinsics.areEqual((Object)src, (Object)this.hexField)) {
            color = ColorValuePanelKt.access$convertHexToColor(this.hexField.getText());
        } else {
            int a = this.getCurrentAlphaFormat() == AlphaFormat.BYTE ? (this.showAlpha ? this.alphaField.getColorValue() : 255) : (this.showAlpha ? MathKt.roundToInt((float)((float)(this.alphaField.getColorValue() * 255) / 100.0f)) : 100);
            switch (ColorValuePanel$WhenMappings.$EnumSwitchMapping$2[this.getCurrentColorFormat().ordinal()]) {
                case 1: {
                    int r = this.colorField1.getColorValue();
                    int g = this.colorField2.getColorValue();
                    int b = this.colorField3.getColorValue();
                    if (this.showAlpha) {
                        color = new Color(r, g, b, a);
                        break;
                    }
                    color = new Color(r, g, b);
                    break;
                }
                case 2: {
                    float h = (float)this.colorField1.getColorValue() / 360.0f;
                    float s = (float)this.colorField2.getColorValue() / 100.0f;
                    float b = (float)this.colorField3.getColorValue() / 100.0f;
                    color = new Color(a << 24 | 0xFFFFFF & Color.HSBtoRGB(h, s, b), this.showAlpha);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        Color color2 = color;
        this.model.setColor(color2, this);
    }

    public ColorValuePanel(@NotNull ColorPickerModel model, boolean showAlpha) {
        super(new GridBagLayout());
        DigitColorDocument $this$apply;
        this.model = model;
        this.showAlpha = showAlpha;
        this.updateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.alphaField = new ColorValueField(false, false, 3, null);
        DigitColorDocument digitColorDocument = new DigitColorDocument(this.alphaField, ColorValuePanelKt.access$getCOLOR_RANGE$p());
        boolean bl = false;
        boolean bl2 = false;
        DigitColorDocument digitColorDocument2 = digitColorDocument;
        ColorValuePanel colorValuePanel = this;
        boolean bl3 = false;
        $this$apply.addDocumentListener(this);
        Unit unit = Unit.INSTANCE;
        colorValuePanel.alphaHexDocument = digitColorDocument;
        digitColorDocument = new DigitColorDocument(this.alphaField, ColorValuePanelKt.access$getPERCENT_RANGE$p());
        bl = false;
        bl2 = false;
        $this$apply = digitColorDocument;
        colorValuePanel = this;
        boolean bl4 = false;
        $this$apply.addDocumentListener(this);
        unit = Unit.INSTANCE;
        colorValuePanel.alphaPercentageDocument = digitColorDocument;
        this.hexField = new ColorValueField(true, this.showAlpha);
        this.alphaLabel = new ColorLabel(null, 1, null);
        this.colorLabel1 = new ColorLabel(null, 1, null);
        this.colorLabel2 = new ColorLabel(null, 1, null);
        this.colorLabel3 = new ColorLabel(null, 1, null);
        this.alphaButtonPanel = ColorValuePanel.Companion.createAlphaLabel(this.alphaLabel, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ColorValuePanel this$0;

            public final void invoke() {
                this.this$0.setCurrentAlphaFormat(this.this$0.getCurrentAlphaFormat().next());
            }
            {
                this.this$0 = colorValuePanel;
                super(0);
            }
        }));
        this.colorFormatButtonPanel = ColorValuePanel.Companion.createFormatLabels(this.colorLabel1, this.colorLabel2, this.colorLabel3, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ColorValuePanel this$0;

            public final void invoke() {
                this.this$0.setCurrentColorFormat(this.this$0.getCurrentColorFormat().next());
            }
            {
                this.this$0 = colorValuePanel;
                super(0);
            }
        }));
        this.colorField1 = new ColorValueField(false, false, 3, null);
        digitColorDocument = new DigitColorDocument(this.colorField1, ColorValuePanelKt.access$getCOLOR_RANGE$p());
        bl = false;
        bl2 = false;
        $this$apply = digitColorDocument;
        colorValuePanel = this;
        boolean bl5 = false;
        $this$apply.addDocumentListener(this);
        unit = Unit.INSTANCE;
        colorValuePanel.redDocument = digitColorDocument;
        digitColorDocument = new DigitColorDocument(this.colorField1, ColorValuePanelKt.access$getHUE_RANGE$p());
        bl = false;
        bl2 = false;
        $this$apply = digitColorDocument;
        colorValuePanel = this;
        boolean bl6 = false;
        $this$apply.addDocumentListener(this);
        unit = Unit.INSTANCE;
        colorValuePanel.hueDocument = digitColorDocument;
        this.colorField2 = new ColorValueField(false, false, 3, null);
        digitColorDocument = new DigitColorDocument(this.colorField2, ColorValuePanelKt.access$getCOLOR_RANGE$p());
        bl = false;
        bl2 = false;
        $this$apply = digitColorDocument;
        colorValuePanel = this;
        boolean bl7 = false;
        $this$apply.addDocumentListener(this);
        unit = Unit.INSTANCE;
        colorValuePanel.greenDocument = digitColorDocument;
        digitColorDocument = new DigitColorDocument(this.colorField2, ColorValuePanelKt.access$getPERCENT_RANGE$p());
        bl = false;
        bl2 = false;
        $this$apply = digitColorDocument;
        colorValuePanel = this;
        boolean bl8 = false;
        $this$apply.addDocumentListener(this);
        unit = Unit.INSTANCE;
        colorValuePanel.saturationDocument = digitColorDocument;
        this.colorField3 = new ColorValueField(false, false, 3, null);
        digitColorDocument = new DigitColorDocument(this.colorField3, ColorValuePanelKt.access$getCOLOR_RANGE$p());
        bl = false;
        bl2 = false;
        $this$apply = digitColorDocument;
        colorValuePanel = this;
        boolean bl9 = false;
        $this$apply.addDocumentListener(this);
        unit = Unit.INSTANCE;
        colorValuePanel.blueDocument = digitColorDocument;
        digitColorDocument = new DigitColorDocument(this.colorField3, ColorValuePanelKt.access$getPERCENT_RANGE$p());
        bl = false;
        bl2 = false;
        $this$apply = digitColorDocument;
        colorValuePanel = this;
        boolean bl10 = false;
        $this$apply.addDocumentListener(this);
        unit = Unit.INSTANCE;
        colorValuePanel.brightnessDocument = digitColorDocument;
        digitColorDocument = Delegates.INSTANCE;
        Enum initialValue$iv = ColorValuePanelKt.access$loadAlphaFormatProperty();
        boolean $i$f$observable = false;
        this.currentAlphaFormat$delegate = (ReadWriteProperty)new ObservableProperty<AlphaFormat>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ ColorValuePanel this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = colorValuePanel;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue2) {
                void newValue3;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                AlphaFormat alphaFormat = (AlphaFormat)((Object)newValue2);
                AlphaFormat alphaFormat2 = (AlphaFormat)((Object)oldValue);
                KProperty $noName_0 = property;
                boolean bl = false;
                ColorValuePanel.access$updateAlphaFormat(this.this$0);
                ColorValuePanelKt.access$saveAlphaFormatProperty((AlphaFormat)newValue3);
                this.this$0.repaint();
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = ColorValuePanelKt.access$loadColorFormatProperty();
        $i$f$observable = false;
        this.currentColorFormat$delegate = (ReadWriteProperty)new ObservableProperty<ColorFormat>((Object)initialValue$iv, (Object)initialValue$iv, this){
            final /* synthetic */ Object $initialValue;
            final /* synthetic */ ColorValuePanel this$0;
            {
                this.$initialValue = $captured_local_variable$1;
                this.this$0 = colorValuePanel;
                super($super_call_param$2);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue2) {
                void newValue3;
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                ColorFormat colorFormat = (ColorFormat)((Object)newValue2);
                ColorFormat colorFormat2 = (ColorFormat)((Object)oldValue);
                KProperty $noName_0 = property;
                boolean bl = false;
                ColorValuePanel.access$updateColorFormat(this.this$0);
                ColorValuePanelKt.access$saveColorFormatProperty((ColorFormat)newValue3);
                this.this$0.repaint();
            }
        };
        this.setBorder((Border)ColorValuePanelKt.access$getPANEL_BORDER$p());
        this.setPreferredSize((Dimension)ColorValuePanelKt.access$getPREFERRED_PANEL_SIZE$p());
        this.setBackground((Color)ColorPickerBuilderKt.getPICKER_BACKGROUND_COLOR());
        this.setFocusable(false);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        if (this.showAlpha) {
            c.weightx = 0.12;
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)this.alphaButtonPanel, c);
            c.gridy = 1;
            this.add((Component)this.alphaField, c);
        }
        c.weightx = 0.36;
        c.gridwidth = 3;
        c.gridx = 1;
        c.gridy = 0;
        this.add((Component)this.colorFormatButtonPanel, c);
        c.gridwidth = 1;
        c.weightx = 0.12;
        c.gridx = 1;
        c.gridy = 1;
        this.add((Component)this.colorField1, c);
        c.gridx = 2;
        c.gridy = 1;
        this.add((Component)this.colorField2, c);
        c.gridx = 3;
        c.gridy = 1;
        this.add((Component)this.colorField3, c);
        c.gridheight = 1;
        c.weightx = 0.51;
        c.gridx = 4;
        c.gridy = 0;
        this.add((Component)new ColorLabel("Hex"), c);
        c.gridy = 1;
        this.add((Component)this.hexField, c);
        this.hexField.setDocument(new HexColorDocument(this.hexField));
        this.hexField.getDocument().addDocumentListener(this);
        this.updateAlphaFormat();
        this.updateColorFormat();
        this.model.addListener(this);
    }

    public /* synthetic */ ColorValuePanel(ColorPickerModel colorPickerModel, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(colorPickerModel, bl);
    }

    public static final /* synthetic */ void access$updateColorToColorModel(ColorValuePanel $this, JTextField src) {
        $this.updateColorToColorModel(src);
    }

    public static final /* synthetic */ void access$updateAlphaFormat(ColorValuePanel $this) {
        $this.updateAlphaFormat();
    }

    public static final /* synthetic */ void access$updateColorFormat(ColorValuePanel $this) {
        $this.updateColorFormat();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\b\u0006*\u0002\u0004\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\nJ3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ui/colorpicker/ColorValuePanel$Companion;", "", "()V", "createAlphaLabel", "com/intellij/ui/colorpicker/ColorValuePanel$Companion$createAlphaLabel$1", "alphaLabel", "Lcom/intellij/ui/colorpicker/ColorLabel;", "onClick", "Lkotlin/Function0;", "", "(Lcom/intellij/ui/colorpicker/ColorLabel;Lkotlin/jvm/functions/Function0;)Lcom/intellij/ui/colorpicker/ColorValuePanel$Companion$createAlphaLabel$1;", "createFormatLabels", "com/intellij/ui/colorpicker/ColorValuePanel$Companion$createFormatLabels$1", "label1", "label2", "label3", "(Lcom/intellij/ui/colorpicker/ColorLabel;Lcom/intellij/ui/colorpicker/ColorLabel;Lcom/intellij/ui/colorpicker/ColorLabel;Lkotlin/jvm/functions/Function0;)Lcom/intellij/ui/colorpicker/ColorValuePanel$Companion$createFormatLabels$1;", "intellij.platform.ide.impl"})
    public static final class Companion {
        private final createAlphaLabel.1 createAlphaLabel(ColorLabel alphaLabel, Function0<Unit> onClick2) {
            return new ButtonPanel(onClick2, alphaLabel){
                final /* synthetic */ Function0 $onClick;
                final /* synthetic */ ColorLabel $alphaLabel;

                public void clicked() {
                    this.$onClick.invoke();
                }
                {
                    this.$onClick = $captured_local_variable$0;
                    this.$alphaLabel = $captured_local_variable$1;
                    this.setLayout(new GridLayout(1, 1));
                    this.add($captured_local_variable$1);
                }
            };
        }

        private final createFormatLabels.1 createFormatLabels(ColorLabel label1, ColorLabel label2, ColorLabel label3, Function0<Unit> onClick2) {
            return new ButtonPanel(onClick2, label1, label2, label3){
                final /* synthetic */ Function0 $onClick;
                final /* synthetic */ ColorLabel $label1;
                final /* synthetic */ ColorLabel $label2;
                final /* synthetic */ ColorLabel $label3;

                public void clicked() {
                    this.$onClick.invoke();
                }
                {
                    this.$onClick = $captured_local_variable$0;
                    this.$label1 = $captured_local_variable$1;
                    this.$label2 = $captured_local_variable$2;
                    this.$label3 = $captured_local_variable$3;
                    this.setLayout(new GridLayout(1, 3));
                    this.add($captured_local_variable$1);
                    this.add($captured_local_variable$2);
                    this.add($captured_local_variable$3);
                }
            };
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

