/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Pair;
import com.intellij.ui.AbstractExpandableItemsHandler;
import com.intellij.ui.AppUIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableHeaderExpandableItemsHandler
extends AbstractExpandableItemsHandler<TableColumn, JTableHeader> {
    protected TableHeaderExpandableItemsHandler(@NotNull JTableHeader component2) {
        super(component2);
    }

    @Override
    @Nullable
    protected Pair<Component, Rectangle> getCellRendererAndBounds(TableColumn column) {
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = ((JTableHeader)this.myComponent).getDefaultRenderer();
        }
        boolean hasFocus = !((JTableHeader)this.myComponent).isPaintingForPrint() && ((JTableHeader)this.myComponent).hasFocus();
        Component comp = renderer.getTableCellRendererComponent(((JTableHeader)this.myComponent).getTable(), column.getHeaderValue(), false, hasFocus, -1, column.getModelIndex());
        AppUIUtil.targetToDevice(comp, this.myComponent);
        Rectangle rect = ((JTableHeader)this.myComponent).getHeaderRect(column.getModelIndex());
        rect.width = comp.getPreferredSize().width;
        return Pair.create((Object)comp, (Object)rect);
    }

    @Override
    protected TableColumn getCellKeyForPoint(Point point) {
        int i2 = ((JTableHeader)this.myComponent).columnAtPoint(point);
        if (i2 >= 0) {
            return ((JTableHeader)this.myComponent).getColumnModel().getColumn(i2);
        }
        return null;
    }
}

