/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.FontInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class FontInfoRenderer
extends ColoredListCellRenderer<Object> {
    protected void customizeCellRenderer(@NotNull JList<?> list2, Object value2, int index, boolean selected2, boolean focused) {
        Font font = list2.getFont();
        String text = value2 == null ? "" : value2.toString();
        this.append(text);
        if (value2 instanceof FontInfo) {
            FontInfo info = (FontInfo)value2;
            Integer size = this.getFontSize();
            Font f = info.getFont(size != null ? size.intValue() : font.getSize());
            if (f.canDisplayUpTo(text) == -1) {
                this.setFont(f);
            } else {
                this.append("  Non-latin", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }
    }

    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(1, this.computePreferredHeight());
    }

    protected void applyAdditionalHints(@NotNull Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)this.isEditorFont()));
    }

    protected Integer getFontSize() {
        return null;
    }

    protected boolean isEditorFont() {
        return false;
    }
}

