/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtilRt;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class EditorComboWithBrowseButton
extends ComponentWithBrowseButton<EditorComboBox>
implements TextAccessor {
    public EditorComboWithBrowseButton(ActionListener browseActionListener, String text, @NotNull Project project, String recentsKey) {
        super((JComponent)((Object)new EditorComboBox(text, project, (FileType)StdFileTypes.PLAIN_TEXT)), browseActionListener);
        List<String> recentEntries = RecentsManager.getInstance(project).getRecentEntries(recentsKey);
        if (recentEntries != null) {
            this.setHistory(ArrayUtilRt.toStringArray(recentEntries));
        }
        if (text != null && text.length() > 0) {
            this.prependItem(text);
        }
    }

    public String getText() {
        return ((EditorComboBox)((Object)this.getChildComponent())).getText().trim();
    }

    public void setText(String text) {
        ((EditorComboBox)((Object)this.getChildComponent())).setText(text);
    }

    public boolean isEditable() {
        return !((EditorComboBox)((Object)this.getChildComponent())).getEditorEx().isViewer();
    }

    public void setHistory(String[] history) {
        ((EditorComboBox)((Object)this.getChildComponent())).setHistory(history);
    }

    public void prependItem(String item) {
        ((EditorComboBox)((Object)this.getChildComponent())).prependItem(item);
    }
}

