/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DuplicateNodeRenderer {
    public static void paintDuplicateNodesBackground(Graphics g, JTree tree) {
        Rectangle clipBounds = g.getClipBounds();
        int start2 = tree.getClosestRowForLocation(clipBounds.x, clipBounds.y);
        int end = Math.min(tree.getRowCount(), tree.getClosestRowForLocation(clipBounds.x + clipBounds.width, clipBounds.y + clipBounds.height) + 1);
        Color old = g.getColor();
        for (int i2 = start2; i2 < end; ++i2) {
            DuplicatableNode duplicatableNode;
            Object duplicate;
            Object userObject;
            DefaultMutableTreeNode node;
            TreePath path = tree.getPathForRow(i2);
            if (path == null) continue;
            Rectangle accumRect = null;
            TreePath accumPath = null;
            for (node = (DefaultMutableTreeNode)path.getLastPathComponent(); node != null && (userObject = node.getUserObject()) instanceof DuplicatableNode && (duplicate = (duplicatableNode = (DuplicatableNode)userObject).getDuplicate()) != null; node = (DefaultMutableTreeNode)node.getParent()) {
                accumPath = accumRect == null ? path : accumPath.getParentPath();
                accumRect = DuplicateNodeRenderer.union(tree.getPathBounds(accumPath), accumRect);
            }
            if (accumRect == null) continue;
            Rectangle rowRect = tree.getRowBounds(tree.getRowForPath(accumPath));
            accumRect = accumRect.intersection(new Rectangle(rowRect.x, rowRect.y, Integer.MAX_VALUE, Integer.MAX_VALUE));
            node = (DefaultMutableTreeNode)accumPath.getLastPathComponent();
            accumRect = DuplicateNodeRenderer.union(accumRect, DuplicateNodeRenderer.getExpandedNodesRect(tree, node, accumPath));
            g.setColor((Color)Gray._230);
            g.fillRoundRect(accumRect.x, accumRect.y, accumRect.width, accumRect.height, 10, 10);
            g.setColor(Color.lightGray);
            g.drawRoundRect(accumRect.x, accumRect.y, accumRect.width, accumRect.height, 10, 10);
        }
        g.setColor(old);
    }

    @NotNull
    private static Rectangle union(Rectangle r1, Rectangle r2) {
        if (r1 == null) {
            return r2;
        }
        if (r2 == null) {
            return r1;
        }
        return r1.union(r2);
    }

    private static Rectangle getExpandedNodesRect(JTree tree, DefaultMutableTreeNode node, TreePath path) {
        Rectangle rect = tree.getRowBounds(tree.getRowForPath(path));
        if (tree.isExpanded(path)) {
            Enumeration<TreeNode> children2 = node.children();
            while (children2.hasMoreElements()) {
                DefaultMutableTreeNode child2 = (DefaultMutableTreeNode)children2.nextElement();
                TreePath childPath = path.pathByAddingChild(child2);
                assert (!path.equals(childPath)) : path + ";" + child2;
                rect = DuplicateNodeRenderer.union(rect, DuplicateNodeRenderer.getExpandedNodesRect(tree, child2, childPath));
            }
        }
        return rect;
    }

    public static interface DuplicatableNode<T> {
        @Nullable
        public T getDuplicate();
    }
}

