/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.impl.NotificationCollector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.impl.IdeRootPane;
import com.intellij.openapi.wm.impl.ToolWindowsPane;
import com.intellij.ui.BalloonImpl;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutConfiguration;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BalloonLayoutImpl
implements BalloonLayout {
    private final ComponentAdapter myResizeListener = new ComponentAdapter(){

        @Override
        public void componentResized(@NotNull ComponentEvent e) {
            BalloonLayoutImpl.this.queueRelayout();
        }
    };
    protected JLayeredPane myLayeredPane;
    private final Insets myInsets;
    protected final List<Balloon> myBalloons = new ArrayList<Balloon>();
    private final Map<Balloon, BalloonLayoutData> myLayoutData = new HashMap<Balloon, BalloonLayoutData>();
    private GetInt myWidth;
    private final Alarm myRelayoutAlarm = new Alarm();
    private final Runnable myRelayoutRunnable = () -> {
        if (this.myLayeredPane == null) {
            return;
        }
        this.relayout();
        this.fireRelayout();
    };
    private JRootPane myParent;
    private final Runnable myCloseAll = () -> {
        for (Balloon balloon : new ArrayList<Balloon>(this.myBalloons)) {
            BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
            NotificationCollector.getInstance().logNotificationBalloonClosedByUser(layoutData.id, layoutData.displayId, layoutData.groupId);
            this.remove(balloon, true);
        }
    };
    private final Runnable myLayoutRunnable = () -> {
        this.calculateSize();
        this.relayout();
        this.fireRelayout();
    };
    private final List<Runnable> myListeners = new ArrayList<Runnable>();

    public BalloonLayoutImpl(@NotNull JRootPane parent, @NotNull Insets insets) {
        this.myParent = parent;
        this.myLayeredPane = parent.getLayeredPane();
        this.myInsets = insets;
        this.myLayeredPane.addComponentListener(this.myResizeListener);
    }

    public void dispose() {
        this.myLayeredPane.removeComponentListener(this.myResizeListener);
        for (Balloon balloon : new ArrayList<Balloon>(this.myBalloons)) {
            Disposer.dispose((Disposable)balloon);
        }
        this.myRelayoutAlarm.cancelAllRequests();
        this.myBalloons.clear();
        this.myLayoutData.clear();
        this.myListeners.clear();
        this.myLayeredPane = null;
        this.myParent = null;
    }

    public void addListener(Runnable listener2) {
        this.myListeners.add(listener2);
    }

    public void removeListener(Runnable listener2) {
        this.myListeners.remove(listener2);
    }

    private void fireRelayout() {
        for (Runnable listener2 : this.myListeners) {
            listener2.run();
        }
    }

    @Nullable
    public Component getTopBalloonComponent() {
        BalloonImpl balloon = (BalloonImpl)ContainerUtil.getLastItem(this.myBalloons);
        return balloon == null ? null : balloon.getComponent();
    }

    public void add(@NotNull Balloon balloon) {
        this.add(balloon, null);
    }

    public void add(final @NotNull Balloon balloon, @Nullable Object layoutData) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Balloon merge = this.merge(layoutData);
        if (merge == null) {
            if (!this.myBalloons.isEmpty() && this.myBalloons.size() == BalloonLayoutImpl.getVisibleCount()) {
                this.remove(this.myBalloons.get(0));
            }
            this.myBalloons.add(balloon);
        } else {
            int index = this.myBalloons.indexOf(merge);
            this.remove(merge);
            this.myBalloons.add(index, balloon);
        }
        if (layoutData instanceof BalloonLayoutData) {
            BalloonLayoutData balloonLayoutData = (BalloonLayoutData)layoutData;
            balloonLayoutData.closeAll = this.myCloseAll;
            balloonLayoutData.doLayout = this.myLayoutRunnable;
            this.myLayoutData.put(balloon, balloonLayoutData);
        }
        Disposer.register((Disposable)balloon, (Disposable)new Disposable(){

            public void dispose() {
                BalloonLayoutImpl.this.clearNMore(balloon);
                BalloonLayoutImpl.this.remove(balloon, false);
                BalloonLayoutImpl.this.queueRelayout();
            }
        });
        this.calculateSize();
        this.relayout();
        if (!balloon.isDisposed()) {
            balloon.show(this.myLayeredPane);
        }
        this.fireRelayout();
    }

    @Nullable
    private Balloon merge(@Nullable Object data2) {
        String mergeId = null;
        if (data2 instanceof String) {
            mergeId = (String)data2;
        } else if (data2 instanceof BalloonLayoutData) {
            mergeId = ((BalloonLayoutData)data2).groupId;
        }
        if (mergeId != null) {
            for (Map.Entry<Balloon, BalloonLayoutData> e : this.myLayoutData.entrySet()) {
                if (!mergeId.equals(e.getValue().groupId)) continue;
                return e.getKey();
            }
        }
        return null;
    }

    @Nullable
    public BalloonLayoutData.MergeInfo preMerge(@NotNull Notification notification) {
        BalloonLayoutData layoutData;
        Balloon balloon = this.merge(notification.getGroupId());
        if (balloon != null && (layoutData = this.myLayoutData.get(balloon)) != null) {
            return layoutData.merge();
        }
        return null;
    }

    public void remove(@NotNull Notification notification) {
        Balloon balloon = this.merge(notification.getGroupId());
        if (balloon != null) {
            this.remove(balloon, true);
        }
    }

    private void remove(@NotNull Balloon balloon) {
        this.remove(balloon, false);
        balloon.hide(true);
        this.fireRelayout();
    }

    private void clearNMore(@NotNull Balloon balloon) {
        BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
        if (layoutData != null && layoutData.project != null && layoutData.mergeData != null) {
            EventLog.clearNMore(layoutData.project, Collections.singleton(layoutData.groupId));
        }
    }

    private void remove(@NotNull Balloon balloon, boolean hide) {
        this.myBalloons.remove(balloon);
        BalloonLayoutData layoutData = this.myLayoutData.remove(balloon);
        if (layoutData != null) {
            layoutData.mergeData = null;
        }
        if (hide) {
            balloon.hide();
            this.fireRelayout();
        }
    }

    public void closeAll() {
        this.myCloseAll.run();
    }

    public void closeFirst() {
        if (!this.myBalloons.isEmpty()) {
            this.remove(this.myBalloons.get(0), true);
        }
    }

    public int getBalloonCount() {
        return this.myBalloons.size();
    }

    private static int getVisibleCount() {
        return Registry.intValue((String)"ide.notification.visible.count", (int)2);
    }

    @NotNull
    private Dimension getSize(@NotNull Balloon balloon) {
        BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
        if (layoutData == null) {
            Dimension size = balloon.getPreferredSize();
            return this.myWidth == null ? size : new Dimension(this.myWidth.i(), size.height);
        }
        return new Dimension(this.myWidth.i(), layoutData.height);
    }

    public boolean isEmpty() {
        return this.myBalloons.isEmpty();
    }

    public void queueRelayout() {
        this.myRelayoutAlarm.cancelAllRequests();
        this.myRelayoutAlarm.addRequest(this.myRelayoutRunnable, 200);
    }

    private void calculateSize() {
        this.myWidth = null;
        for (Balloon balloon : this.myBalloons) {
            BalloonLayoutData layoutData = this.myLayoutData.get(balloon);
            if (layoutData == null) continue;
            layoutData.height = balloon.getPreferredSize().height;
        }
        this.myWidth = BalloonLayoutConfiguration::FixedWidth;
    }

    private void relayout() {
        Dimension size = this.myLayeredPane.getSize();
        JBInsets.removeFrom((Dimension)size, (Insets)this.myInsets);
        Rectangle layoutRec = new Rectangle(new Point(this.myInsets.left, this.myInsets.top), size);
        List<ArrayList<Balloon>> columns = this.createColumns(layoutRec);
        while (columns.size() > 1) {
            this.remove(this.myBalloons.get(0), true);
            columns = this.createColumns(layoutRec);
        }
        ToolWindowsPane pane2 = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)this.myParent, ToolWindowsPane.class));
        JComponent layeredPane = pane2 != null ? pane2.getLayeredPane() : null;
        int eachColumnX = (layeredPane == null ? this.myLayeredPane.getWidth() : layeredPane.getX() + layeredPane.getWidth()) - 4;
        this.doLayout((List<Balloon>)columns.get(0), eachColumnX + 4, (int)this.myLayeredPane.getBounds().getMaxY());
    }

    private void doLayout(List<Balloon> balloons, int startX, int bottomY) {
        int y = bottomY;
        ToolWindowsPane pane2 = (ToolWindowsPane)((Object)UIUtil.findComponentOfType((JComponent)this.myParent, ToolWindowsPane.class));
        if (pane2 != null) {
            y -= pane2.getBottomHeight();
        }
        if (this.myParent instanceof IdeRootPane) {
            y -= ((IdeRootPane)this.myParent).getStatusBarHeight();
        }
        for (Balloon balloon : balloons) {
            Rectangle bounds2 = new Rectangle(this.getSize(balloon));
            bounds2.setLocation(startX - bounds2.width, y -= bounds2.height);
            balloon.setBounds(bounds2);
        }
    }

    private List<ArrayList<Balloon>> createColumns(Rectangle layoutRec) {
        ArrayList<ArrayList<Balloon>> columns = new ArrayList<ArrayList<Balloon>>();
        ArrayList<Balloon> eachColumn = new ArrayList<Balloon>();
        columns.add(eachColumn);
        int eachColumnHeight = 0;
        for (Balloon each : this.myBalloons) {
            Dimension eachSize = this.getSize(each);
            if ((double)(eachColumnHeight + eachSize.height) > layoutRec.getHeight()) {
                eachColumn = new ArrayList();
                columns.add(eachColumn);
                eachColumnHeight = 0;
            }
            eachColumn.add(each);
            eachColumnHeight += eachSize.height;
        }
        return columns;
    }

    private static interface GetInt {
        public int i();
    }
}

