/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.terminal.TerminalExecutionConsole;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompositeFilterWrapper {
    private final Project myProject;
    private final TerminalExecutionConsole myConsole;
    private final List<Filter> myFilters = new CopyOnWriteArrayList<Filter>();

    CompositeFilterWrapper(@NotNull Project project, @Nullable TerminalExecutionConsole console) {
        this.myProject = project;
        this.myConsole = console;
    }

    void addFilter(@NotNull Filter filter2) {
        this.myFilters.add(filter2);
    }

    @NotNull
    private List<Filter> createCompositeFilters() {
        if (this.myProject.isDefault()) {
            return Collections.emptyList();
        }
        return (List)ReadAction.compute(() -> {
            if (this.myProject.isDisposed()) {
                return Collections.emptyList();
            }
            return ConsoleViewUtil.computeConsoleFilters(this.myProject, this.myConsole, GlobalSearchScope.allScope((Project)this.myProject));
        });
    }

    @NotNull
    CompositeFilter getCompositeFilter() {
        ArrayList<Filter> filters = new ArrayList<Filter>(this.myFilters);
        filters.addAll(this.createCompositeFilters());
        CompositeFilter filter2 = new CompositeFilter(this.myProject, filters);
        filter2.setForceUseAllFilters(true);
        return filter2;
    }
}

