/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.impl.ExecuteRunConfigurationTaskImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExecutionEnvironmentProviderImpl
implements ExecutionEnvironmentProvider {
    private static final Logger LOG = Logger.getInstance(ExecutionEnvironmentProvider.class);

    @Nullable
    public ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull RunProfile runProfile, @NotNull Executor executor, @NotNull ExecutionTarget target2, @Nullable RunnerSettings runnerSettings2, @Nullable ConfigurationPerRunnerSettings configurationSettings, @Nullable RunnerAndConfigurationSettings settings) {
        ExecuteRunConfigurationTaskImpl runTask = new ExecuteRunConfigurationTaskImpl(runProfile, target2, runnerSettings2, configurationSettings, settings);
        return (ExecutionEnvironment)ProjectTaskRunner.EP_NAME.computeSafeIfAny(projectTaskRunner -> {
            try {
                if (projectTaskRunner.canRun(project, (ProjectTask)runTask)) {
                    return projectTaskRunner.createExecutionEnvironment(project, runTask, executor);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error("Broken project task runner: " + projectTaskRunner.getClass().getName(), (Throwable)e);
            }
            return null;
        });
    }
}

