/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.slicer.SliceNode;
import com.intellij.slicer.SliceUsage;
import com.intellij.usageView.UsageInfo;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DuplicateMap {
    private static final TObjectHashingStrategy<SliceUsage> USAGE_INFO_EQUALITY = new TObjectHashingStrategy<SliceUsage>(){

        public int computeHashCode(SliceUsage object) {
            UsageInfo info = object.getUsageInfo();
            ProperTextRange range2 = info.getRangeInElement();
            return range2 == null ? 0 : range2.hashCode();
        }

        public boolean equals(SliceUsage o1, SliceUsage o2) {
            return o1.getUsageInfo().equals((Object)o2.getUsageInfo());
        }
    };
    private final Map<SliceUsage, SliceNode> myDuplicates = new THashMap(USAGE_INFO_EQUALITY);

    SliceNode putNodeCheckDupe(@NotNull SliceNode node) {
        return (SliceNode)ReadAction.compute(() -> {
            SliceUsage usage = (SliceUsage)((Object)((Object)node.getValue()));
            return this.myDuplicates.putIfAbsent(usage, node);
        });
    }

    public void clear() {
        this.myDuplicates.clear();
    }
}

