/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.execution.services.ServiceViewContributor;
import com.intellij.execution.services.ServiceViewDescriptor;
import com.intellij.execution.services.ServiceViewManager;
import com.intellij.execution.services.ServiceViewProvidingContributor;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.SingleRemoteServerConfigurable;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersDeploymentManager;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteServersServiceViewContributor
implements ServiceViewContributor<RemoteServerNodeServiceViewContributor>,
Comparator<RemoteServerNodeServiceViewContributor>,
ServersTreeStructure.DeploymentNodeProducer {
    public abstract boolean accept(@NotNull RemoteServer<?> var1);

    public abstract void selectLog(@NotNull AbstractTreeNode<?> var1, @NotNull String var2);

    @NotNull
    public abstract ActionGroups getActionGroups();

    @NotNull
    protected RemoteServerNodeServiceViewContributor createNodeContributor(@NotNull AbstractTreeNode<?> node) {
        return new RemoteServerNodeServiceViewContributor(this, node);
    }

    @NotNull
    public List<RemoteServerNodeServiceViewContributor> getServices(@NotNull Project project) {
        List<RemoteServerNodeServiceViewContributor> services = RemoteServersManager.getInstance().getServers().stream().filter(this::accept).map(server -> this.createNodeContributor(new ServersTreeStructure.RemoteServerNode(project, (RemoteServer<?>)server, this))).collect(Collectors.toList());
        RemoteServersDeploymentManager.getInstance(project).registerContributor(this);
        return services;
    }

    @NotNull
    public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull RemoteServerNodeServiceViewContributor service) {
        return service.getViewDescriptor(project);
    }

    @Override
    public int compare(RemoteServerNodeServiceViewContributor o1, RemoteServerNodeServiceViewContributor o2) {
        Function getName = contributor -> Optional.ofNullable(contributor).map(RemoteServerNodeServiceViewContributor::asService).map(o -> (ServersTreeStructure.RemoteServerNode)ObjectUtils.tryCast((Object)o, ServersTreeStructure.RemoteServerNode.class)).map(node -> node.getServer().getName()).orElse(null);
        String name1 = (String)getName.fun((Object)o1);
        String name2 = (String)getName.fun((Object)o2);
        if (name1 == null || name2 == null) {
            if (name1 == null && name2 == null) {
                return 0;
            }
            return name1 == null ? -1 : 1;
        }
        return name1.compareTo(name2);
    }

    @NotNull
    protected static ActionGroup getToolbarActions(@NotNull ActionGroups groups) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction(groups.getMainToolbarID()));
        return group;
    }

    @NotNull
    protected static ActionGroup getPopupActions(@NotNull ActionGroups groups) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction(groups.getMainToolbarID()));
        group.add(ActionManager.getInstance().getAction(groups.getPopupID()));
        return group;
    }

    private static String generateUniqueServerName(ServerType<?> serverType) {
        List servers = ContainerUtil.filter((Collection)RemoteServersManager.getInstance().getServers(), server -> server.getType().equals(serverType));
        return UniqueNameGenerator.generateUniqueName((String)serverType.getPresentableName(), s -> {
            for (RemoteServer server : servers) {
                if (!server.getName().equals(s)) continue;
                return false;
            }
            return true;
        });
    }

    public static <C extends ServerConfiguration> RemoteServer<C> addNewRemoteServer(@NotNull Project project, @NotNull ServerType<C> serverType, @Nullable Class<?> contributorClass) {
        String name = RemoteServersServiceViewContributor.generateUniqueServerName(serverType);
        RemoteServersManager remoteServersManager = RemoteServersManager.getInstance();
        RemoteServer server = remoteServersManager.createServer(serverType, name);
        SingleRemoteServerConfigurable configurable2 = new SingleRemoteServerConfigurable(server, null, true);
        configurable2.setDisplayName(CloudBundle.message((String)"new.cloud.connection.configurable.title", (Object[])new Object[]{serverType.getPresentableName()}));
        Runnable advancedInitialization = () -> {
            configurable2.setDisplayName(name);
            configurable2.updateName();
        };
        if (ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable2, advancedInitialization)) {
            remoteServersManager.addServer(server);
            if (contributorClass != null) {
                ServerConnectionManager.getInstance().getOrCreateConnection(server).connect(EmptyRunnable.INSTANCE);
                ServersTreeStructure.RemoteServerNode node = new ServersTreeStructure.RemoteServerNode(project, server, (connection, serverNode, deployment) -> null);
                ServiceViewManager.getInstance((Project)project).select((Object)node, contributorClass, true, true);
            }
            return server;
        }
        return null;
    }

    public static class ActionGroups {
        @NotNull
        private final String myMainToolbarID;
        @NotNull
        private final String mySecondaryToolbarID;
        @NotNull
        private final String myPopupID;
        public static final ActionGroups SHARED_ACTION_GROUPS = new ActionGroups("RemoteServersViewToolbar", "RemoteServersViewToolbar.Top", "RemoteServersViewPopup");

        public ActionGroups(@NotNull String mainToolbarID, @NotNull String secondaryToolbarID, @NotNull String popupID) {
            this.myMainToolbarID = mainToolbarID;
            this.mySecondaryToolbarID = secondaryToolbarID;
            this.myPopupID = popupID;
        }

        @NotNull
        public String getMainToolbarID() {
            return this.myMainToolbarID;
        }

        @NotNull
        public String getPopupID() {
            return this.myPopupID;
        }

        @NotNull
        public String getSecondaryToolbarID() {
            return this.mySecondaryToolbarID;
        }
    }

    public static class RemoteServerNodeServiceViewContributor
    implements ServiceViewProvidingContributor<RemoteServerNodeServiceViewContributor, AbstractTreeNode<?>> {
        private final RemoteServersServiceViewContributor myRootContributor;
        private final AbstractTreeNode<?> myNode;

        protected RemoteServerNodeServiceViewContributor(@NotNull RemoteServersServiceViewContributor rootContributor, @NotNull AbstractTreeNode<?> node) {
            this.myRootContributor = rootContributor;
            this.myNode = node;
        }

        @NotNull
        public AbstractTreeNode<?> asService() {
            return this.myNode;
        }

        @NotNull
        public ServiceViewDescriptor getViewDescriptor(@NotNull Project project) {
            return new RemoteServerNodeDescriptor(this.myNode, this.myRootContributor.getActionGroups());
        }

        @NotNull
        public List<RemoteServerNodeServiceViewContributor> getServices(@NotNull Project project) {
            return ContainerUtil.map((Collection)this.myNode.getChildren(), this.myRootContributor::createNodeContributor);
        }

        @NotNull
        public ServiceViewDescriptor getServiceDescriptor(@NotNull Project project, @NotNull RemoteServerNodeServiceViewContributor service) {
            return service.getViewDescriptor(project);
        }

        @NotNull
        protected RemoteServersServiceViewContributor getRootContributor() {
            return this.myRootContributor;
        }
    }

    public static class RemoteServerNodeDescriptor
    implements ServiceViewDescriptor {
        private final AbstractTreeNode<?> myNode;
        private final ActionGroups myActionGroups;

        protected RemoteServerNodeDescriptor(@NotNull AbstractTreeNode<?> node, @NotNull ActionGroups actionGroups) {
            this.myNode = node;
            this.myActionGroups = actionGroups;
        }

        @Nullable
        public String getId() {
            if (this.myNode instanceof ServersTreeStructure.RemoteServerNode) {
                ((ServersTreeStructure.RemoteServerNode)this.myNode).getServer().getName();
            }
            if (this.myNode instanceof DeploymentNode) {
                ((DeploymentNode)this.myNode).getDeploymentName();
            }
            return this.getPresentation().getPresentableText();
        }

        public JComponent getContentComponent() {
            if (this.myNode instanceof ServersTreeStructure.LogProvidingNode) {
                return ((ServersTreeStructure.LogProvidingNode)this.myNode).getComponent();
            }
            if (this.myNode instanceof ServersTreeStructure.RemoteServerNode) {
                return RemoteServersDeploymentManager.getInstance(this.myNode.getProject()).getServerContent(((ServersTreeStructure.RemoteServerNode)this.myNode).getServer());
            }
            return null;
        }

        public ActionGroup getToolbarActions() {
            return RemoteServersServiceViewContributor.getToolbarActions(this.myActionGroups);
        }

        public ActionGroup getPopupActions() {
            return RemoteServersServiceViewContributor.getPopupActions(this.myActionGroups);
        }

        @NotNull
        public ItemPresentation getPresentation() {
            return this.myNode.getPresentation();
        }

        public boolean handleDoubleClick(@NotNull MouseEvent event) {
            AnAction connectAction = ActionManager.getInstance().getAction("RemoteServers.ConnectServer");
            DataContext dataContext = DataManager.getInstance().getDataContext(event.getComponent());
            AnActionEvent actionEvent = AnActionEvent.createFromAnAction((AnAction)connectAction, (InputEvent)event, (String)"unknown", (DataContext)dataContext);
            connectAction.actionPerformed(actionEvent);
            return true;
        }

        @Nullable
        public Runnable getRemover() {
            AbstractTreeNode<?> node = this.getNode();
            if (node instanceof ServersTreeStructure.RemoteServerNode) {
                return () -> RemoteServersManager.getInstance().removeServer(((ServersTreeStructure.RemoteServerNode)node).getServer());
            }
            return null;
        }

        @NotNull
        protected AbstractTreeNode<?> getNode() {
            return this.myNode;
        }
    }
}

