/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.agent.impl.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UrlCollector {
    private static final Logger LOG = Logger.getInstance(UrlCollector.class);
    private List<File> myFiles;

    public URL[] collect(@NotNull Collection<File> libraries) {
        List<File> files2 = this.collectFiles(libraries);
        URL[] result2 = new URL[files2.size()];
        for (int i2 = 0; i2 < files2.size(); ++i2) {
            try {
                result2[i2] = files2.get(i2).toURI().toURL();
                continue;
            }
            catch (MalformedURLException e) {
                LOG.error((Throwable)e);
            }
        }
        return result2;
    }

    public List<File> collectFiles(Collection<File> libraries) {
        this.myFiles = new ArrayList<File>();
        for (File library : libraries) {
            if (!library.exists()) continue;
            this.addFile(library);
            if (!library.isDirectory()) continue;
            this.addLibraries(library);
        }
        return this.myFiles;
    }

    private void addLibraries(@NotNull File dir) {
        LOG.debug("addLibraries: " + dir.getAbsolutePath() + ", exists: " + dir.exists());
        File[] subFiles = dir.listFiles();
        if (subFiles == null) {
            LOG.warn("Can't list files in " + dir);
            return;
        }
        for (File file2 : subFiles) {
            if (file2.isDirectory()) {
                this.addLibraries(file2);
                continue;
            }
            if (!file2.getName().endsWith(".jar")) continue;
            this.addFile(file2);
        }
    }

    private void addFile(@NotNull File file2) {
        LOG.debug("addFile: " + file2.getAbsolutePath() + ", exists: " + file2.exists());
        this.myFiles.add(file2);
    }
}

