/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote.ext;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.remote.CredentialsType;
import com.intellij.remote.OutdatedCredentialsType;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.ext.UnknownCredentialsHolder;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Pair;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CredentialsManager {
    public static CredentialsManager getInstance() {
        return (CredentialsManager)ServiceManager.getService(CredentialsManager.class);
    }

    public abstract List<CredentialsType<?>> getAllTypes();

    public abstract void loadCredentials(String var1, @Nullable Element var2, RemoteSdkAdditionalData var3);

    public static void updateOutdatedSdk(@NotNull RemoteSdkAdditionalData<?> data2, @Nullable Project project) {
        if (!(data2.getRemoteConnectionType() instanceof OutdatedCredentialsType)) {
            return;
        }
        Pair pair = ((OutdatedCredentialsType)((Object)data2.getRemoteConnectionType())).transformToNewerType(data2.connectionCredentials().getCredentials(), project);
        data2.setCredentials(((CredentialsType)pair.getFirst()).getCredentialsKey(), pair.getSecond());
    }

    public static void recogniseCredentialType(@NotNull Stream<? extends SdkAdditionalData> additionalData, @NotNull CredentialsType<?> credentialsType) {
        additionalData.forEach(data2 -> CredentialsManager.recogniseCredentialType(data2, credentialsType));
    }

    private static void recogniseCredentialType(@Nullable SdkAdditionalData additionalData, @NotNull CredentialsType credentialsType) {
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return;
        }
        RemoteSdkAdditionalData data2 = (RemoteSdkAdditionalData)additionalData;
        if (data2.getRemoteConnectionType() != CredentialsType.UNKNOWN) {
            return;
        }
        String credentialsId = data2.connectionCredentials().getId();
        if (!credentialsType.hasPrefix(credentialsId)) {
            return;
        }
        Element root = new Element("root");
        data2.connectionCredentials().save(root);
        Object credentials = credentialsType.createCredentials();
        credentialsType.getHandler(credentials).load(root);
        data2.setCredentials(credentialsType.getCredentialsKey(), credentials);
    }

    public static void forgetCredentialType(@NotNull Stream<? extends SdkAdditionalData> additionalData, @NotNull CredentialsType<?> credentialsType) {
        additionalData.forEach(data2 -> CredentialsManager.forgetCredentialType(data2, credentialsType));
    }

    private static void forgetCredentialType(@Nullable SdkAdditionalData additionalData, @NotNull CredentialsType<?> credentialsType) {
        if (!(additionalData instanceof RemoteSdkAdditionalData)) {
            return;
        }
        RemoteSdkAdditionalData data2 = (RemoteSdkAdditionalData)additionalData;
        if (data2.getRemoteConnectionType() != credentialsType) {
            return;
        }
        Element root = new Element("root");
        data2.connectionCredentials().save(root);
        UnknownCredentialsHolder unknownCredentials = CredentialsType.UNKNOWN.createCredentials();
        unknownCredentials.setSdkId(data2.getSdkId());
        CredentialsType.UNKNOWN.getHandler(unknownCredentials).load(root);
        data2.setCredentials(CredentialsType.UNKNOWN.getCredentialsKey(), unknownCredentials);
    }
}

