/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.find.findUsages.FindUsagesHelper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.TextOccurenceProcessor;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageInfoFactory;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class TextOccurrencesUtilBase {
    private TextOccurrencesUtilBase() {
    }

    public static void addTextOccurrences(@NotNull PsiElement element2, @NotNull String stringToSearch, @NotNull GlobalSearchScope searchScope, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory2) {
        FindUsagesHelper.processTextOccurrences(element2, stringToSearch, searchScope, factory2, (Processor<? super UsageInfo>)((Processor)t -> {
            results.add((UsageInfo)t);
            return true;
        }));
    }

    public static boolean processUsagesInStringsAndComments(@NotNull Processor<? super UsageInfo> processor2, @NotNull PsiElement element2, @NotNull SearchScope searchScope, @NotNull String stringToSearch, @NotNull UsageInfoFactory factory2) {
        return TextOccurrencesUtilBase.processUsagesInStringsAndComments(element2, searchScope, stringToSearch, false, (PairProcessor<? super PsiElement, ? super TextRange>)((PairProcessor)(commentOrLiteral, textRange) -> {
            UsageInfo usageInfo = factory2.createUsageInfo(commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
            return usageInfo == null || processor2.process((Object)usageInfo);
        }));
    }

    public static boolean processUsagesInStringsAndComments(@NotNull PsiElement element2, @NotNull SearchScope searchScope, @NotNull String stringToSearch, boolean ignoreReferences, @NotNull PairProcessor<? super PsiElement, ? super TextRange> processor2) {
        Processor commentOrLiteralProcessor;
        PsiSearchHelper helper = PsiSearchHelper.getInstance((Project)element2.getProject());
        SearchScope scope = helper.getUseScope(element2);
        return TextOccurrencesUtilBase.processStringLiteralsContainingIdentifier(stringToSearch, scope = scope.intersectWith(searchScope), helper, (Processor<? super PsiElement>)(commentOrLiteralProcessor = literal -> TextOccurrencesUtilBase.processTextIn(literal, stringToSearch, ignoreReferences, processor2))) && helper.processCommentsContainingIdentifier(stringToSearch, scope, commentOrLiteralProcessor);
    }

    private static boolean processStringLiteralsContainingIdentifier(@NotNull String identifier, @NotNull SearchScope searchScope, PsiSearchHelper helper, Processor<? super PsiElement> processor2) {
        TextOccurenceProcessor occurenceProcessor = (element2, offsetInElement) -> {
            ParserDefinition definition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(element2.getLanguage());
            ASTNode node = element2.getNode();
            if (definition != null && node != null && definition.getStringLiteralElements().contains(node.getElementType())) {
                return processor2.process((Object)element2);
            }
            return true;
        };
        return helper.processElementsWithWord(occurenceProcessor, searchScope, identifier, (short)4, true);
    }

    private static boolean processTextIn(PsiElement scope, String stringToSearch, boolean ignoreReferences, PairProcessor<? super PsiElement, ? super TextRange> processor2) {
        String text = scope.getText();
        for (int offset = 0; offset < text.length() && (offset = text.indexOf(stringToSearch, offset)) >= 0; ++offset) {
            char c;
            PsiReference referenceAt = scope.findReferenceAt(offset);
            if (!ignoreReferences && referenceAt != null && (referenceAt.resolve() != null || referenceAt instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)referenceAt).multiResolve(true).length > 0) || offset > 0 && Character.isJavaIdentifierPart(c = text.charAt(offset - 1)) && c != '$' && (offset < 2 || text.charAt(offset - 2) != '\\') || offset + stringToSearch.length() < text.length() && Character.isJavaIdentifierPart(c = text.charAt(offset + stringToSearch.length())) && c != '$') continue;
            TextRange textRange = new TextRange(offset, offset + stringToSearch.length());
            if (!processor2.process((Object)scope, (Object)textRange)) {
                return false;
            }
            offset += stringToSearch.length();
        }
        return true;
    }

    public static void addUsagesInStringsAndComments(@NotNull PsiElement element2, @NotNull SearchScope searchScope, @NotNull String stringToSearch, @NotNull Collection<? super UsageInfo> results, @NotNull UsageInfoFactory factory2) {
        Object lock = new Object();
        TextOccurrencesUtilBase.processUsagesInStringsAndComments(element2, searchScope, stringToSearch, false, (PairProcessor<? super PsiElement, ? super TextRange>)((PairProcessor)(commentOrLiteral, textRange) -> {
            UsageInfo usageInfo = factory2.createUsageInfo(commentOrLiteral, textRange.getStartOffset(), textRange.getEndOffset());
            if (usageInfo != null) {
                Object object = lock;
                synchronized (object) {
                    results.add(usageInfo);
                }
            }
            return true;
        }));
    }
}

