/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import org.jetbrains.annotations.NotNull;

class DefaultNonCodeSearchElementDescriptionProvider
implements ElementDescriptionProvider {
    static final DefaultNonCodeSearchElementDescriptionProvider INSTANCE = new DefaultNonCodeSearchElementDescriptionProvider();

    DefaultNonCodeSearchElementDescriptionProvider() {
    }

    public String getElementDescription(@NotNull PsiElement element2, @NotNull ElementDescriptionLocation location) {
        PsiMetaOwner psiMetaOwner;
        PsiMetaData metaData;
        if (!(location instanceof NonCodeSearchDescriptionLocation)) {
            return null;
        }
        NonCodeSearchDescriptionLocation ncdLocation = (NonCodeSearchDescriptionLocation)location;
        if (element2 instanceof PsiDirectory) {
            if (ncdLocation.isNonJava()) {
                String qName = PsiDirectoryFactory.getInstance(element2.getProject()).getQualifiedName((PsiDirectory)element2, false);
                if (qName.length() > 0) {
                    return qName;
                }
                return null;
            }
            return ((PsiDirectory)element2).getName();
        }
        if (element2 instanceof PsiMetaOwner && (metaData = (psiMetaOwner = (PsiMetaOwner)element2).getMetaData()) != null) {
            return metaData.getName();
        }
        if (element2 instanceof PsiNamedElement) {
            return ((PsiNamedElement)element2).getName();
        }
        return null;
    }
}

