/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.refactoring.rename.NameSuggestionProvider;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MyLookupExpression
extends Expression {
    protected final String myName;
    protected final LookupElement[] myLookupItems;
    private final String myAdvertisementText;
    private volatile LookupFocusDegree myLookupFocusDegree = LookupFocusDegree.FOCUSED;

    public MyLookupExpression(String name, @Nullable LinkedHashSet<String> names2, @Nullable PsiNamedElement elementToRename, @Nullable PsiElement nameSuggestionContext, boolean shouldSelectAll, String advertisement) {
        this.myName = name;
        this.myAdvertisementText = advertisement;
        this.myLookupItems = MyLookupExpression.initLookupItems(names2, elementToRename, nameSuggestionContext, shouldSelectAll);
    }

    private static LookupElement[] initLookupItems(@Nullable LinkedHashSet<String> names2, @Nullable PsiNamedElement elementToRename, @Nullable PsiElement nameSuggestionContext, final boolean shouldSelectAll) {
        if (names2 == null) {
            if (elementToRename == null) {
                return LookupElement.EMPTY_ARRAY;
            }
            names2 = new LinkedHashSet();
            NameSuggestionProvider.suggestNames((PsiElement)elementToRename, (PsiElement)nameSuggestionContext, names2);
        }
        LookupElement[] lookupElements = new LookupElement[names2.size()];
        Iterator iterator2 = names2.iterator();
        for (int i2 = 0; i2 < lookupElements.length; ++i2) {
            final String suggestion = (String)iterator2.next();
            lookupElements[i2] = LookupElementBuilder.create((String)suggestion).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
                    TextRange range2;
                    if (shouldSelectAll) {
                        return;
                    }
                    Editor topLevelEditor = InjectedLanguageUtil.getTopLevelEditor(context.getEditor());
                    TemplateState templateState = TemplateManagerImpl.getTemplateState(topLevelEditor);
                    if (templateState != null && (range2 = templateState.getCurrentVariableRange()) != null) {
                        topLevelEditor.getDocument().replaceString(range2.getStartOffset(), range2.getEndOffset(), (CharSequence)suggestion);
                    }
                }
            });
        }
        return lookupElements;
    }

    public LookupElement[] calculateLookupItems(ExpressionContext context) {
        return this.myLookupItems;
    }

    public Result calculateQuickResult(ExpressionContext context) {
        return this.calculateResult(context);
    }

    public Result calculateResult(ExpressionContext context) {
        TextResult insertedValue;
        TemplateState templateState = TemplateManagerImpl.getTemplateState(context.getEditor());
        TextResult textResult = insertedValue = templateState != null ? templateState.getVariableValue("PrimaryVariable") : null;
        if (insertedValue != null && !insertedValue.getText().isEmpty()) {
            return insertedValue;
        }
        return new TextResult(this.myName);
    }

    public boolean requiresCommittedPSI() {
        return false;
    }

    public String getAdvertisingText() {
        return this.myAdvertisementText;
    }

    @NotNull
    public LookupFocusDegree getLookupFocusDegree() {
        return this.myLookupFocusDegree;
    }

    public void setLookupFocusDegree(@NotNull LookupFocusDegree lookupFocusDegree) {
        this.myLookupFocusDegree = lookupFocusDegree;
    }
}

