/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move;

import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.MoveHandlerDelegate;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveHandler
implements RefactoringActionHandler {
    @Deprecated
    public static final String REFACTORING_NAME = "Move";

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        PsiReference reference2;
        int offset = editor.getCaretModel().getOffset();
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement element2 = file2.findElementAt(offset);
        if (element2 == null) {
            element2 = file2;
        }
        if ((reference2 = MoveHandler.findReferenceAtCaret(element2, offset)) != null) {
            PsiElement refElement = reference2.resolve();
            for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (refElement == null || !delegate.tryToMove(refElement, project, dataContext, reference2, editor)) continue;
                MoveHandler.logDelegate(project, delegate, refElement.getLanguage());
                return;
            }
        }
        List<MoveHandlerDelegate> candidateHandlers = MoveHandler.findHandlersForLanguage(element2);
        while (true) {
            if (element2 == null) {
                String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"the.caret.should.be.positioned.at.the.class.method.or.field.to.be.refactored"));
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)MoveHandler.getRefactoringName(), null);
                return;
            }
            for (MoveHandlerDelegate delegate : candidateHandlers) {
                if (!delegate.tryToMove(element2, project, dataContext, null, editor)) continue;
                MoveHandler.logDelegate(project, delegate, element2.isValid() ? element2.getLanguage() : null);
                return;
            }
            element2 = element2.getParent();
        }
    }

    private static void logDelegate(@NotNull Project project, @NotNull MoveHandlerDelegate delegate, @Nullable Language language) {
        FeatureUsageData data2 = new FeatureUsageData().addLanguage(language).addData("handler", delegate.getClass().getName());
        FUCounterUsageLogger.getInstance().logEvent(project, "move.refactoring", "handler.invoked", data2);
    }

    private static PsiReference findReferenceAtCaret(PsiElement element2, int caretOffset) {
        TextRange range2 = element2.getTextRange();
        if (range2 != null) {
            int relative = caretOffset - range2.getStartOffset();
            return element2.findReferenceAt(relative);
        }
        return null;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
        PsiElement targetContainer = dataContext == null ? null : (PsiElement)LangDataKeys.TARGET_PSI_ELEMENT.getData(dataContext);
        HashSet<PsiElement> filesOrDirs = new HashSet<PsiElement>();
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(dataContext) || !delegate.isValidTarget(targetContainer, elements2)) continue;
            delegate.collectFilesOrDirsFromContext(dataContext, filesOrDirs);
        }
        if (!filesOrDirs.isEmpty()) {
            for (PsiElement element2 : elements2) {
                if (element2 instanceof PsiDirectory) {
                    filesOrDirs.add(element2);
                    continue;
                }
                PsiFile containingFile = element2.getContainingFile();
                if (containingFile == null) continue;
                filesOrDirs.add((PsiElement)containingFile);
            }
            FUCounterUsageLogger.getInstance().logEvent(project, "move.refactoring", "move.files.or.directories");
            MoveFilesOrDirectoriesUtil.doMove(project, PsiUtilCore.toPsiElementArray(filesOrDirs), new PsiElement[]{targetContainer}, null);
            return;
        }
        MoveHandler.doMove(project, elements2, targetContainer, dataContext, null);
    }

    public static void doMove(Project project, PsiElement @NotNull [] elements2, PsiElement targetContainer, DataContext dataContext, MoveCallback callback2) {
        if (elements2.length == 0) {
            return;
        }
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(elements2, targetContainer, null)) continue;
            MoveHandler.logDelegate(project, delegate, elements2[0].getLanguage());
            delegate.doMove(project, elements2, delegate.adjustTargetForMove(dataContext, targetContainer), callback2);
            break;
        }
    }

    public static PsiElement @Nullable [] adjustForMove(Project project, PsiElement[] sourceElements, PsiElement targetElement) {
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(sourceElements, targetElement, null)) continue;
            return delegate.adjustForMove(project, sourceElements, targetElement);
        }
        return sourceElements;
    }

    public static boolean canMove(PsiElement @NotNull [] elements2, PsiElement targetContainer) {
        return MoveHandler.findDelegate(elements2, targetContainer, null) != null;
    }

    @Nullable
    private static MoveHandlerDelegate findDelegate(PsiElement @NotNull [] elements2, @Nullable PsiElement targetContainer, @Nullable PsiReference reference2) {
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(elements2, targetContainer, reference2)) continue;
            return delegate;
        }
        return null;
    }

    @Nullable
    public static String getActionName(@NotNull DataContext dataContext) {
        Editor editor = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            MoveHandlerDelegate refDelegate;
            PsiElement refElement;
            PsiReference reference2;
            Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                return null;
            }
            PsiFile file2 = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (file2 == null) {
                return null;
            }
            PsiElement element2 = file2.findElementAt(editor.getCaretModel().getOffset());
            if (element2 == null) {
                element2 = file2;
            }
            if ((reference2 = MoveHandler.findReferenceAtCaret(element2, editor.getCaretModel().getOffset())) != null && (refElement = reference2.resolve()) != null && (refDelegate = MoveHandler.findDelegate(new PsiElement[]{refElement}, null, reference2)) != null) {
                return refDelegate.getActionName(new PsiElement[]{refElement});
            }
            List<MoveHandlerDelegate> candidateHandlers = MoveHandler.findHandlersForLanguage(element2);
            while (element2 != null) {
                PsiElement[] elementArray = new PsiElement[]{element2};
                for (MoveHandlerDelegate handler2 : candidateHandlers) {
                    if (!handler2.canMove(elementArray, null, reference2)) continue;
                    return handler2.getActionName(elementArray);
                }
                element2 = element2.getParent();
            }
            return null;
        }
        PsiElement[] elements2 = BaseRefactoringAction.getPsiElementArray(dataContext);
        List delegates = MoveHandlerDelegate.EP_NAME.getExtensionList();
        for (MoveHandlerDelegate delegate : delegates) {
            if (!delegate.canMove(elements2, null, null)) continue;
            return delegate.getActionName(elements2);
        }
        return null;
    }

    @NotNull
    private static List<MoveHandlerDelegate> findHandlersForLanguage(@NotNull PsiElement element2) {
        return ContainerUtil.filter((Collection)MoveHandlerDelegate.EP_NAME.getExtensionList(), delegate -> delegate.supportsLanguage(element2.getLanguage()));
    }

    public static boolean isValidTarget(PsiElement psiElement, PsiElement[] elements2) {
        if (psiElement != null) {
            for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
                if (!delegate.isValidTarget(psiElement, elements2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canMove(DataContext dataContext) {
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.canMove(dataContext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMoveRedundant(PsiElement source, PsiElement target2) {
        for (MoveHandlerDelegate delegate : MoveHandlerDelegate.EP_NAME.getExtensionList()) {
            if (!delegate.isMoveRedundant(source, target2)) continue;
            return true;
        }
        return false;
    }

    public static String getRefactoringName() {
        return RefactoringBundle.message((String)"move.title");
    }
}

