/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.TitledHandler;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.lang.ExtractIncludeDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.ReplacePromptDialog;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExtractIncludeFileBase<T extends PsiElement>
implements RefactoringActionHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(ExtractIncludeFileBase.class);
    protected PsiFile myIncludingFile;
    public static final String HELP_ID = "refactoring.extractInclude";
    private static PsiDirectory ourTargetDirectory = null;
    private static String ourTargetFileName = null;

    public boolean isAvailableForFile(@NotNull PsiFile file2) {
        return true;
    }

    protected abstract void doReplaceRange(String var1, T var2, T var3);

    @NotNull
    protected String doExtract(PsiDirectory targetDirectory, String targetfileName, T first, T last, Language includingLanguage) throws IncorrectOperationException {
        PsiFile file2 = targetDirectory.createFile(targetfileName);
        Project project = targetDirectory.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file2);
        document.replaceString(0, document.getTextLength(), (CharSequence)first.getText().trim());
        documentManager.commitDocument(document);
        CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)project).getProject()).reformat((PsiElement)file2);
        String relativePath = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)first.getContainingFile(), (PsiFileSystemItem)file2);
        if (relativePath == null) {
            throw new IncorrectOperationException("Cannot extract!");
        }
        return relativePath;
    }

    protected abstract boolean verifyChildRange(T var1, T var2);

    private void replaceDuplicates(String includePath, List<IncludeDuplicate<T>> duplicates, Editor editor, Project project) {
        String message;
        int exitCode;
        if (duplicates.size() > 0 && (exitCode = Messages.showYesNoDialog((Project)project, (String)(message = RefactoringBundle.message((String)"idea.has.found.fragments.that.can.be.replaced.with.include.directive", (Object[])new Object[]{ApplicationNamesInfo.getInstance().getProductName()})), (String)this.getRefactoringName(), (Icon)Messages.getInformationIcon())) == 0) {
            CommandProcessor.getInstance().executeCommand(project, () -> {
                boolean replaceAll = false;
                for (IncludeDuplicate pair : duplicates) {
                    if (!replaceAll) {
                        ExtractIncludeFileBase.highlightInEditor(project, pair, editor);
                        ReplacePromptDialog promptDialog = new ReplacePromptDialog(false, RefactoringBundle.message((String)"replace.fragment"), project);
                        promptDialog.show();
                        int promptResult = promptDialog.getExitCode();
                        if (promptResult == 2) continue;
                        if (promptResult == 1) break;
                        if (promptResult == 0) {
                            this.doReplaceRange(includePath, pair.getStart(), pair.getEnd());
                            continue;
                        }
                        if (promptResult == 3) {
                            this.doReplaceRange(includePath, pair.getStart(), pair.getEnd());
                            replaceAll = true;
                            continue;
                        }
                        LOG.error("Unknown return status");
                        continue;
                    }
                    this.doReplaceRange(includePath, pair.getStart(), pair.getEnd());
                }
            }, RefactoringBundle.message((String)"remove.duplicates.command"), null);
        }
    }

    private static void highlightInEditor(Project project, IncludeDuplicate pair, Editor editor) {
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        int startOffset = pair.getStart().getTextRange().getStartOffset();
        int endOffset = pair.getEnd().getTextRange().getEndOffset();
        highlightManager.addRangeHighlight(editor, startOffset, endOffset, EditorColors.SEARCH_RESULT_ATTRIBUTES, true, null);
        LogicalPosition logicalPosition = editor.offsetToLogicalPosition(startOffset);
        editor.getScrollingModel().scrollTo(logicalPosition, ScrollType.MAKE_VISIBLE);
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
    }

    @NotNull
    protected Language getLanguageForExtract(PsiElement firstExtracted) {
        return firstExtracted.getLanguage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
        try {
            this.myIncludingFile = file2;
            this.doInvoke(project, editor, file2);
        }
        finally {
            this.myIncludingFile = null;
        }
    }

    protected void doInvoke(@NotNull Project project, Editor editor, PsiFile file2) {
        int end;
        if (!editor.getSelectionModel().hasSelection()) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"no.selection"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)HELP_ID);
            return;
        }
        int start2 = editor.getSelectionModel().getSelectionStart();
        Pair<T, T> children2 = this.findPairToExtract(start2, end = editor.getSelectionModel().getSelectionEnd());
        if (children2 == null) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selection.does.not.form.a.fragment.for.extraction"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (!this.verifyChildRange((PsiElement)children2.getFirst(), (PsiElement)children2.getSecond())) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"cannot.extract.selected.elements.into.include.file"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)HELP_ID);
            return;
        }
        LanguageFileType fileType = this.getLanguageForExtract((PsiElement)children2.getFirst()).getAssociatedFileType();
        if (fileType == null) {
            String message = RefactoringBundle.message((String)"the.language.for.selected.elements.has.no.associated.file.type");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)this.getRefactoringName(), (String)HELP_ID);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file2)) {
            return;
        }
        Pair<PsiDirectory, String> directoryAndFileName = this.getTargetDirectoryAndFileName(file2, (FileType)fileType, children2);
        if (directoryAndFileName.first == null || directoryAndFileName.second == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                ArrayList duplicates = new ArrayList();
                PsiElement first = (PsiElement)children2.getFirst();
                PsiElement second = (PsiElement)children2.getSecond();
                PsiEquivalenceUtil.findChildRangeDuplicates((PsiElement)first, (PsiElement)second, (PsiElement)file2, (start1, end1) -> duplicates.add(new IncludeDuplicate((PsiElement)start1, (PsiElement)end1, null)));
                String includePath = this.processPrimaryFragment(first, second, (PsiDirectory)directoryAndFileName.first, (String)directoryAndFileName.second, file2);
                editor.getCaretModel().moveToOffset(first.getTextRange().getStartOffset());
                ApplicationManager.getApplication().invokeLater(() -> this.replaceDuplicates(includePath, duplicates, editor, project));
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorMessage((String)this.getRefactoringName(), (String)e.getMessage(), null, (Project)project);
            }
            editor.getSelectionModel().removeSelection();
        }), this.getRefactoringName(), null);
    }

    public static void setTestingTargetFile(@Nullable PsiDirectory targetDirectory, @Nullable String targetFileName, @NotNull Disposable parentDisposable) {
        ourTargetFileName = targetFileName;
        ourTargetDirectory = targetDirectory;
        Disposer.register((Disposable)parentDisposable, () -> {
            ourTargetFileName = null;
            ourTargetDirectory = null;
        });
    }

    @NotNull
    private Pair<PsiDirectory, String> getTargetDirectoryAndFileName(@NotNull PsiFile file2, FileType fileType, @NotNull Pair<T, T> children2) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return Pair.create((Object)ourTargetDirectory, (Object)ourTargetFileName);
        }
        ExtractIncludeDialog dialog2 = this.createDialog(file2.getContainingDirectory(), this.getExtractExtension(fileType, (PsiElement)children2.first));
        dialog2.show();
        if (dialog2.getExitCode() != 0) {
            return Pair.create(null, null);
        }
        PsiDirectory targetDirectory = dialog2.getTargetDirectory();
        String targetFileName = dialog2.getTargetFileName();
        LOG.assertTrue(targetDirectory != null && targetFileName != null);
        return Pair.create((Object)targetDirectory, (Object)targetFileName);
    }

    protected ExtractIncludeDialog createDialog(PsiDirectory containingDirectory, String extractExtension) {
        return new ExtractIncludeDialog(containingDirectory, extractExtension);
    }

    @Nullable
    protected abstract Pair<T, T> findPairToExtract(int var1, int var2);

    @NonNls
    protected String getExtractExtension(FileType extractFileType, T first) {
        return extractFileType.getDefaultExtension();
    }

    @Deprecated
    public boolean isValidRange(T firstToExtract, T lastToExtract) {
        return this.verifyChildRange(firstToExtract, lastToExtract);
    }

    public String processPrimaryFragment(T firstToExtract, T lastToExtract, PsiDirectory targetDirectory, String targetfileName, PsiFile srcFile) throws IncorrectOperationException {
        String includePath = this.doExtract(targetDirectory, targetfileName, firstToExtract, lastToExtract, srcFile.getLanguage());
        this.doReplaceRange(includePath, firstToExtract, lastToExtract);
        return includePath;
    }

    public String getActionTitle() {
        return RefactoringBundle.message((String)"extract.include.file.action.title");
    }

    protected String getRefactoringName() {
        return ExtractIncludeFileBase.getRefactoringNameText();
    }

    static String getRefactoringNameText() {
        return RefactoringBundle.message((String)"extract.include.file.title");
    }

    private static class IncludeDuplicate<E extends PsiElement> {
        private final SmartPsiElementPointer<E> myStart;
        private final SmartPsiElementPointer<E> myEnd;

        private IncludeDuplicate(E start2, E end) {
            this.myStart = SmartPointerManager.getInstance((Project)start2.getProject()).createSmartPsiElementPointer(start2);
            this.myEnd = SmartPointerManager.getInstance((Project)start2.getProject()).createSmartPsiElementPointer(end);
        }

        E getStart() {
            return (E)this.myStart.getElement();
        }

        E getEnd() {
            return (E)this.myEnd.getElement();
        }

        /* synthetic */ IncludeDuplicate(PsiElement x0, PsiElement x1, 1 x2) {
            this(x0, x1);
        }
    }
}

