/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.lang;

import com.intellij.ide.util.DirectoryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.ex.FileTypeChooser;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileSystemItemUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.IncorrectOperationException;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class ExtractIncludeDialog
extends DialogWrapper {
    private final PsiDirectory myCurrentDirectory;
    protected final String myExtension;
    protected TextFieldWithBrowseButton myTargetDirectoryField;
    private JTextField myNameField;
    protected JLabel myTargetDirLabel;
    private PsiDirectory myTargetDirectory;

    public ExtractIncludeDialog(PsiDirectory currentDirectory, String extension) {
        super(true);
        this.myCurrentDirectory = currentDirectory;
        this.myExtension = extension;
        this.setTitle(ExtractIncludeDialog.getRefactoringName());
        this.init();
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    public String getTargetFileName() {
        String name = this.myNameField.getText().trim();
        return name.contains(".") ? name : name + "." + this.myExtension;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        JLabel nameLabel = new JLabel();
        panel2.add(nameLabel);
        this.myNameField = new JTextField();
        nameLabel.setLabelFor(this.myNameField);
        this.myNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ExtractIncludeDialog.this.validateOKButton();
            }
        });
        panel2.add(this.myNameField);
        nameLabel.setText(this.getNameLabel());
        this.myTargetDirLabel = new JLabel();
        panel2.add(this.myTargetDirLabel);
        this.myTargetDirectoryField = new TextFieldWithBrowseButton();
        this.myTargetDirectoryField.setText(this.myCurrentDirectory.getVirtualFile().getPresentableUrl());
        this.myTargetDirectoryField.addBrowseFolderListener(RefactoringBundle.message((String)"select.target.directory"), RefactoringBundle.message((String)"select.target.directory.description"), null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        this.myTargetDirLabel.setText(RefactoringBundle.message((String)"extract.to.directory"));
        panel2.add((Component)this.myTargetDirectoryField);
        this.myTargetDirectoryField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(@NotNull DocumentEvent event) {
                ExtractIncludeDialog.this.validateOKButton();
            }
        });
        this.validateOKButton();
        return panel2;
    }

    protected String getNameLabel() {
        return RefactoringBundle.message((String)"name.for.extracted.include.file", (Object[])new Object[]{this.myExtension});
    }

    private void validateOKButton() {
        String fileName = this.myNameField.getText().trim();
        this.setOKActionEnabled(this.myTargetDirectoryField.getText().trim().length() > 0 && fileName.length() > 0 && fileName.indexOf(File.separatorChar) < 0 && !StringUtil.containsAnyChar((String)fileName, (String)"*?><\":;|") && fileName.indexOf(".") != 0);
    }

    private static boolean isFileExist(@NotNull String directory, @NotNull String fileName) {
        return LocalFileSystem.getInstance().findFileByIoFile(new File(directory, fileName)) != null;
    }

    protected void doOKAction() {
        String targetFileName;
        Project project = this.myCurrentDirectory.getProject();
        String directoryName = this.myTargetDirectoryField.getText().replace(File.separatorChar, '/');
        if (ExtractIncludeDialog.isFileExist(directoryName, targetFileName = this.getTargetFileName())) {
            Messages.showErrorDialog((Project)project, (String)RefactoringBundle.message((String)"file.already.exist", (Object[])new Object[]{targetFileName}), (String)RefactoringBundle.message((String)"file.already.exist.title"));
            return;
        }
        FileType type = FileTypeChooser.getKnownFileTypeOrAssociate(targetFileName);
        if (type == null) {
            return;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            Runnable action2 = () -> {
                try {
                    PsiDirectory targetDirectory = DirectoryUtil.mkdirs(PsiManager.getInstance((Project)project), directoryName);
                    assert (targetDirectory != null) : directoryName;
                    targetDirectory.checkCreateFile(targetFileName);
                    String webPath = PsiFileSystemItemUtil.findRelativePath((PsiFileSystemItem)this.myCurrentDirectory, (PsiFileSystemItem)targetDirectory);
                    this.myTargetDirectory = webPath == null ? null : targetDirectory;
                }
                catch (IncorrectOperationException e) {
                    CommonRefactoringUtil.showErrorMessage((String)ExtractIncludeDialog.getRefactoringName(), (String)e.getMessage(), null, (Project)project);
                }
            };
            ApplicationManager.getApplication().runWriteAction(action2);
        }, RefactoringBundle.message((String)"create.directory"), null);
        if (this.myTargetDirectory == null) {
            return;
        }
        super.doOKAction();
    }

    protected String getHelpId() {
        return "refactoring.extractInclude";
    }

    protected void hideTargetDirectory() {
        this.myTargetDirectoryField.setVisible(false);
        this.myTargetDirLabel.setVisible(false);
    }

    private static String getRefactoringName() {
        return RefactoringBundle.message((String)"extractIncludeFile.name");
    }
}

