/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature.inplace;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.inplace.InplaceChangeSignature;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.inplace.LanguageChangeSignatureDetectors;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ApplyChangeSignatureAction
extends BaseRefactoringIntentionAction {
    public static final String CHANGE_SIGNATURE = "Apply signature change";
    private final String myMethodName;

    public ApplyChangeSignatureAction(String methodName) {
        this.myMethodName = methodName;
    }

    @NotNull
    public String getText() {
        return RefactoringBundle.message((String)"changing.signature.of.0", (Object[])new Object[]{this.myMethodName});
    }

    @NotNull
    public String getFamilyName() {
        return CHANGE_SIGNATURE;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element2.getLanguage());
        if (detector != null) {
            ChangeInfo currentInfo;
            InplaceChangeSignature changeSignature = InplaceChangeSignature.getCurrentRefactoring(editor);
            ChangeInfo changeInfo = currentInfo = changeSignature != null ? changeSignature.getCurrentInfo() : null;
            if (currentInfo != null && detector.isChangeSignatureAvailableOnElement(element2, currentInfo)) {
                return true;
            }
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        InplaceChangeSignature signatureGestureDetector = InplaceChangeSignature.getCurrentRefactoring(editor);
        String initialSignature = signatureGestureDetector.getInitialSignature();
        ChangeInfo currentInfo = signatureGestureDetector.getCurrentInfo();
        signatureGestureDetector.detach();
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element2.getLanguage());
        detector.performChange(currentInfo, editor, initialSignature);
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return file2;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

