/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.actions;

import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.lang.LanguageRefactoringSupport;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BasePlatformRefactoringAction;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeSignatureAction
extends BasePlatformRefactoringAction {
    public ChangeSignatureAction() {
        this.setInjectedContext(true);
    }

    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(PsiElement @NotNull [] elements2) {
        if (elements2.length == 1) {
            PsiElement member = ChangeSignatureAction.findTargetMember(elements2[0]);
            return member != null && ChangeSignatureAction.getChangeSignatureHandler(member) != null;
        }
        return false;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element2, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        PsiElement targetMember = ChangeSignatureAction.findTargetMember(element2);
        if (targetMember == null) {
            ChangeSignatureHandler targetHandler = ChangeSignatureAction.getChangeSignatureHandler((PsiElement)file2);
            return targetHandler != null;
        }
        ChangeSignatureHandler targetHandler = ChangeSignatureAction.getChangeSignatureHandler(targetMember);
        return targetHandler != null;
    }

    @Nullable
    private static PsiElement findTargetMember(@Nullable PsiElement element2) {
        PsiElement targetMember;
        if (element2 == null) {
            return null;
        }
        ChangeSignatureHandler fileHandler = ChangeSignatureAction.getChangeSignatureHandler(element2);
        if (fileHandler != null && (targetMember = fileHandler.findTargetMember(element2)) != null) {
            return targetMember;
        }
        PsiReference reference2 = element2.getReference();
        if (reference2 == null && element2 instanceof PsiNameIdentifierOwner) {
            return element2;
        }
        if (reference2 != null) {
            return reference2.resolve();
        }
        return null;
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider) {
        return provider.getChangeSignatureHandler();
    }

    @Override
    @Nullable
    protected RefactoringActionHandler getRefactoringHandler(@NotNull RefactoringSupportProvider provider, final PsiElement element2) {
        abstract class ContextAwareChangeSignatureHandler
        implements RefactoringActionHandler,
        ContextAwareActionHandler {
            ContextAwareChangeSignatureHandler() {
            }
        }
        return new ContextAwareChangeSignatureHandler(){
            {
            }

            public boolean isAvailableForQuickList(@NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext dataContext) {
                return ChangeSignatureAction.findTargetMember(element2) != null;
            }

            public void invoke(@NotNull Project project, Editor editor, PsiFile file2, DataContext dataContext) {
                editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                PsiElement targetMember = ChangeSignatureAction.findTargetMember(element2);
                if (targetMember == null) {
                    String notFoundMessage;
                    ChangeSignatureHandler handler2 = ChangeSignatureAction.getChangeSignatureHandler((PsiElement)file2);
                    if (handler2 != null && (notFoundMessage = handler2.getTargetNotFoundMessage()) != null) {
                        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)notFoundMessage, (String)ChangeSignatureHandler.REFACTORING_NAME, null);
                    }
                    return;
                }
                ChangeSignatureHandler handler3 = ChangeSignatureAction.getChangeSignatureHandler(targetMember);
                if (handler3 == null) {
                    return;
                }
                handler3.invoke(project, new PsiElement[]{targetMember}, dataContext);
            }

            public void invoke(@NotNull Project project, PsiElement @NotNull [] elements2, DataContext dataContext) {
                if (elements2.length != 1) {
                    return;
                }
                PsiElement targetMember = ChangeSignatureAction.findTargetMember(elements2[0]);
                if (targetMember == null) {
                    return;
                }
                ChangeSignatureHandler handler2 = ChangeSignatureAction.getChangeSignatureHandler(targetMember);
                if (handler2 == null) {
                    return;
                }
                handler2.invoke(project, new PsiElement[]{targetMember}, dataContext);
            }
        };
    }

    @Nullable
    private static ChangeSignatureHandler getChangeSignatureHandler(@NotNull PsiElement language) {
        RefactoringSupportProvider provider = LanguageRefactoringSupport.INSTANCE.forContext(language);
        return provider != null ? provider.getChangeSignatureHandler() : null;
    }
}

